import json
from shapely.geometry import shape
import rdflib as rdf

from rdflib.namespace import RDFS
from rdflib.namespace import RDF
from rdflib.namespace import SKOS
from rdflib.namespace import XSD


def zpracuj_zaznam_zchu(soubor):
    data = json.load(soubor)
    features = data['features']
    print(f"Počet záznamů v souboru {len(features)}")
    for row in features:
        # Type
        p = row["properties"]
        current_id = p["OBJECTID"]
        current_zchu = zchu_namespace[str(current_id)]
        category = cat_switch[p["KAT"]]
        if p["IUCN"] != " ":
            current_iucn = iucn_namespace[p["IUCN"]]
            graph.add((current_iucn, RDF.type, uri_kategorie_iucn))
            graph.add((current_iucn, SKOS.prefLabel, rdf.Literal(p["IUCN"], datatype=XSD.string)))
            graph.add((current_zchu, uri_ma_kategorii_iucn, current_iucn))

        graph.add((current_zchu, RDF.type, category))
        graph.add((current_zchu, uri_ma_nazev, rdf.Literal(p["NAZEV"], datatype=XSD.string)))
        graph.add((current_zchu, uri_ma_kod_v_db, rdf.Literal(p["KOD"], datatype=XSD.int)))

        # Geometry
        g = row["geometry"]
        geom = shape(g)
        asWkt = "<http://www.opengis.net/def/crs/OGC/1.3/CRS84> " + geom.wkt

        graph.add((current_zchu, rdf.RDF.type, geo_namespace["Feature"]))
        geo_poloha = poloha_namespace[str(current_id)]
        graph.add((uri_poloha, rdf.RDFS.subClassOf, geo_namespace["Geometry"]))
        graph.add((geo_poloha, rdf.RDF.type, uri_poloha))
        graph.add((current_zchu, uri_ma_polohu, geo_poloha))
        graph.add((geo_poloha, rdf.RDFS.label,
                   rdf.Literal("Poloha " + cat_poloha_label[p["KAT"]] + " " + str(rdf.Literal(p["NAZEV"])))))
        graph.add((geo_poloha, geo_namespace["asWKT"], rdf.Literal(asWkt, datatype=rdf.URIRef(
            "http://www.opengis.net/ont/geosparql#wktLiteral"))))

if __name__ == '__main__':
    graph = rdf.Graph()

     # Add namespaces
    zchu_namespace = rdf.Namespace("http://osw.felk.cvut.cz/medmicha/zvláště-chráněná-území/")
    iucn_namespace = rdf.Namespace("http://osw.felk.cvut.cz/medmicha/iucn/")
    poloha_namespace = rdf.Namespace("http://osw.felk.cvut.cz/medmicha/zvláště-chráněná-území/poloha/")

    # ontologie - legislativa?
    zchu_s_namespace = rdf.Namespace("http://osw.felk.cvut.cz/medmicha/ontologies/zvláště-chráněná-území/")
    skos_namespace = rdf.Namespace('http://www.w3.org/2004/02/skos/core#')
    geo_namespace = rdf.Namespace('http://www.opengis.net/ont/geosparql#')

    graph.bind('zchu', zchu_namespace)
    graph.bind('zchu-s', zchu_s_namespace)
    graph.bind('zchu-poloha', poloha_namespace)
    graph.bind('skos', skos_namespace)
    graph.bind('geo', geo_namespace)
    graph.bind('iucn', iucn_namespace)

    # Prepare categories
    uri_mzchu = zchu_s_namespace["maloplošné-zvláště-chráněné-území"]
    uri_vzchu = zchu_s_namespace["velkoplošné-zvláště-chráněné-území"]
    uri_prirodni_pamatka = zchu_s_namespace["přírodní-památka"]
    uri_narodni_prirodni_pamatka = zchu_s_namespace["národní-přírodní-památka"]
    uri_prirodni_rezervace = zchu_s_namespace["přírodní-rezervace"]
    uri_narodni_prirodni_rezervace = zchu_s_namespace["národní-přírodní-rezervace"]
    uri_narodni_park = zchu_s_namespace["národní-park"]
    uri_chko = zchu_s_namespace["chráněná-krajinná-oblast"]
    uri_ochranne_pasmo = zchu_s_namespace["ochranné-pásmo"]

    uri_ma_nazev = zchu_s_namespace["má-název"]
    uri_kategorie_iucn = zchu_s_namespace["kategorie-ochrany-iucn"]
    uri_ma_kategorii_iucn = zchu_s_namespace["má-kategorii-ochrany-iucn"]
    uri_ma_kod_v_db = zchu_s_namespace["má-kód-v-databázi"]
    uri_ma_polohu = zchu_s_namespace["má-polohu"]
    uri_poloha = zchu_s_namespace["poloha-zvláště-chráněného-území"]

    # Categories
    cat_switch={
      "NPP":uri_narodni_prirodni_pamatka,
      "PP":uri_prirodni_pamatka,
      "NPR":uri_narodni_prirodni_rezervace,
      "PR":uri_prirodni_rezervace,
      "CHKO":uri_chko,
      "NP":uri_narodni_park,
      "OP":uri_ochranne_pasmo
      }

    cat_poloha_label={
      "NPP":"národní přírodní památky",
      "PP":"přírodní památky",
      "NPR":"národní přírodní rezervace",
      "PR":"přírodní rezervace",
      "CHKO":"chráněné krajinné oblasti",
      "NP":"národního parku",
      "OP":"ochranného pásma"
    }

    with open('./mzchu.geojson', encoding='utf-8') as mzchu:
        zpracuj_zaznam_zchu(mzchu)

    with open('./vzchu.geojson', encoding='utf-8') as vzchu:
        zpracuj_zaznam_zchu(vzchu)

    graph.serialize(destination="./zchu.ttl", format="turtle")
