/*
Code for task3 - laboratory exercise 6
Jiri J, 2024
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>


/** 
 * @brief Structure to store a contact's details.
 */
typedef struct{
	char name[100];
	int age;
} contact;


/**
 * @brief Clears any remaining characters in the input buffer, up to and including
 * a newline (`\n`) or until EOF.
 *
 * This function is useful for discarding unwanted input after an invalid entry 
 * or after reading numeric input, which does not consume the newline.
 * 
 * @param pFile The file stream to clear (e.g., `stdin`).
 */
void clear_input(FILE *pFile){
	int ch;
	while ((ch = fgetc(pFile)) != '\n' && ch != EOF);
}



/**
 * @brief Reads a new contact's details from the given file stream and adds it to
 * the list of contacts. Reallocates memory for the contact list if successful.
 *
 * @param pFile Pointer to the stream to read from (`stdin` for user input).
 * @param contacts Pointer to the dynamically allocated array of contacts.
 * @param num_contacts Pointer to the count of contacts, updated if the new contact is added.
 *
 * @return `0` if successful, `-1` if input is invalid or EOF, `-2` if memory allocation fails.
 */
int add_contact(FILE* pFile, contact** contacts, int* num_contacts){
	contact new_contact;
	
	// read name
	if (pFile == stdin){
		printf("Enter name: ");
	}
	if (fgets(new_contact.name, sizeof(new_contact.name), pFile) == NULL){
		return -1;
	}
	// remove new line (if any)
	new_contact.name[strcspn(new_contact.name, "\n")] = '\0';
	
	
	// read user input - age
	if (pFile == stdin){
		printf("Enter age: ");
	}
	if (fscanf(pFile, "%d", &new_contact.age) != 1){
		return -1;
	}
	clear_input(pFile);

	// realloc the array
	(*contacts) = (contact*) realloc(*contacts, (*num_contacts + 1) * sizeof(contact));
	if (*contacts == NULL){
		printf("Allocation error\n");
		return -2;
	}
	
	// add new contact
	(*contacts)[*num_contacts] = new_contact;
	(*num_contacts)++;
	
	return 0;
}



/**
 * @brief Prints all stored contacts, displaying the name and age of each.
 * 
 * @param contacts Array of contact structures to display.
 * @param num_contacts Number of contacts stored in the array.
 */
void print_contacts(contact* contacts, int num_contacts){
	printf("----------------------------------------\n");
	for (int i = 0; i < num_contacts; i++) {
		printf("===User %d===\n", i);
		printf("Name: %s\n", contacts[i].name);
		printf("Age: %d\n", contacts[i].age);
	}
	printf("----------------------------------------\n");
}


/**
 * @brief Deletes a contact from the list by index.
 * 
 * Reallocates memory to shrink the contacts array.
 * 
 * @param pFile Pointer to the stream to read from (`stdin` for user input).
 * @param contacts Pointer to the array of contact pointers.
 * @param num_contacts Pointer to the number of contacts.
 * 
 * @return 0 if successful, -1 on input error, and -2 on memory allocation error.
 */
int delete_contact(FILE* pFile, contact** contacts, int* num_contacts){

	// read name
	char name[100];
	if (pFile == stdin){
		printf("Enter name: ");
	}
	if (fgets(name, sizeof(name), pFile) == NULL){
		return -1;
	}
	// remove new line (if any)
	name[strcspn(name, "\n")] = '\0';
	
	// find index of the name
	int index = -1;
	for(int i = 0; i < *num_contacts; i++){
		if (strcmp((*contacts)[i].name, name) == 0){
			index = i;
			break;
		}
	}
	if (index < 0){
		return -1;
	}
	
	// shift following contacts and decrement number
	for (int i = index; i < (*num_contacts)-1; i++){
		(*contacts)[i] = (*contacts)[i+1];
	}
	(*num_contacts)--;
	
	// realloc array
	(*contacts) = (contact*) realloc(*contacts, *num_contacts * sizeof(contact));
	if (*num_contacts > 0 && *contacts == NULL){
		printf("Allocation error\n");
		return -2;
	}

	return 0;

}


int main(int argc, char* argv[]){

	// init variables
	contact* contacts = NULL;
	int num_contacts = 0;
	int key;
	int exit = 0;
	FILE *pFile;
	
	// open a file called people.txt in READ mode to load existing contacts
	pFile = fopen("people.txt", "r");
	
	// if opening failed exit
	if(pFile == NULL){
		printf("No existing contacts found\n");
	// otherwise read all contacts
	}else{
		while(1){
			int ret = add_contact(pFile, &contacts, &num_contacts);
			if (ret == -1){
				break;
			}else if(ret == -2){
				free(contacts);
				return -1;
			}
		}
		// close file
		fclose(pFile);
	}
	
	// print all contacts
	print_contacts(contacts, num_contacts);
	
	// allow user to add contacts
	pFile = stdin;
	while(!exit){
		printf("1. add contact\n");
		printf("2. view all contacts\n");
		printf("3. delete contact\n");
		printf("4. exit\n");
		printf("Press key to continue: ");
		
		// read key
		if (scanf("%d", &key) != 1){
			printf("Invalid key\n");
			clear_input(pFile);
			continue;
		}
		clear_input(pFile);
		
		switch (key){
			// add contact - read from stdin
			case 1:
				// add contact
				if(add_contact(pFile, &contacts, &num_contacts) < 0){
					free(contacts);
					return -1;
				}
				// save contacts to file
				FILE *file = fopen("people.txt", "a");
				if (file == NULL) {
				    printf("Failed to open file for appending\n");
				    free(contacts);
				    return -1;
				}
				fprintf(file, "%s\n%d\n", contacts[num_contacts-1].name, contacts[num_contacts-1].age);
				fclose(file);
				break;
			
			// view all contacts
			case 2:
				print_contacts(contacts, num_contacts);
				break;
				
			// delete contact
			case 3:
				// delete contact
				int ret = delete_contact(pFile, &contacts, &num_contacts);
				if (ret == -1){
					continue;
				}else if(ret == -2){
					free(contacts);
					return -1;
				}else{
					// save remaining contacts to file
					FILE *file = fopen("people.txt", "w");
					if (file == NULL) {
					    printf("Failed to open file for writing\n");
					    free(contacts);
					    return -1;
					}
					for(int i = 0; i < num_contacts; i++){
						fprintf(file, "%s\n%d\n", contacts[i].name, contacts[i].age);
					}
					fclose(file);
				}
				
				break;
			
			// exit
			case 4:
				printf("Exiting program\n");
				exit = 1;
				break;
			default:
				printf("Invalid key, try again\n");
		}
	
	}
	
	
	// free allocated memory
	free(contacts);

	return 0;
}
