# Čte text ze standardního vstupu a vypisuje jeho lexikální analýzu

import sys

def analyzuj(f):
  """ Čte text ze souboru 'f' a analyzuje """
  interpunkce=""".,;:?!"'()"""
  mezery=" \t\n"
  stav=0 # počáteční stav - mimo slovo
  while True:
    c=f.read(1) # přečti jeden znak
    if c=="":   # konec souboru  
      return
    if stav==0:
      if c in interpunkce:
        print("Interpunkce: ",c)
      elif c not in mezery:  # je to znak slova
        slovo=c               # akumulátor slova
        stav=1                 
    else:  # stav==1 - uvnitř slova  
      if c not in interpunkce and c not in mezery:
        slovo+=c # pořád uvnitř slova
      else:      # slovo končí
        print("Slovo:       ",slovo)
        stav=0
        if c in interpunkce:  
          print("Interpunkce: ",c)

if __name__=="__main__":
  analyzuj(sys.stdin)
