<?php

class Calendar {

    public static function getDayInYear($day, $month, $year = 0) {
        if ($year == 0) {
            $year = date("Y", time());
        }
       if (!Calendar::dateExists($day, $month, $year)) {
           return -1;
       }
       $time = mktime(0,0,0,intval($month), intval($day), intval($year));
       return date("z", $time)+1;
    }

    public static function dateExists($day, $month, $year) {
        return checkdate(intval($month), intval($day), intval($year));
    }

    public static function getFormattedDate($day, $month, $year, $format) {
        $day = intval($day);
        $month = intval($month);
        $year = intval($year);

        if (!Calendar::dateExists($day, $month, $year)) {
            return null;
        }

        return date($format, mktime(0,0,0,$month, $day, $year));
    }


}

?>
