#include <iostream>
#include <cstddef>
#include <algorithm>

void copy_array(const double* from, double* to, size_t size) {
    std::copy_n(from, size, to);
     
    /* ~ Ekvivalentní s
    for (size_t i = 0; i < size; ++i) {
        to[i] = from[i];
    }
    */
}

void print_array(const double* arr, size_t size) {
    bool first = true;
    for (size_t i = 0; i < size; ++i) {
        std::cout << arr[i];
        if (!first){
            std::cout << ' ';
        }
        first = false;
    }
    std::cout << '\n';
}

void resize_array(double*& arr, size_t oldSize, size_t newSize) {
    double* newArr = new double[newSize];
    size_t minSize = (oldSize < newSize) ? oldSize : newSize;
    copy_array(arr, newArr, minSize);
    delete[] arr;
    arr = newArr;
}

struct vector {
    double* data = nullptr;
    size_t capacity = 0;
    size_t size = 0;
};

void print_vector(const vector& v) {
    std::cout << "capacity: " << v.capacity << " size: " << v.size << " data: ";
    print_array(v.data, v.size);
}

void dispose(vector& v) {
    delete[] v.data;
}

void reserve(vector& v, size_t capacity) {
    if (v.capacity < capacity) {
        resize_array(v.data, v.size, capacity);
        v.capacity = capacity;
    }
}

void push_back(vector& v, double val) {
    if (v.size == v.capacity) {
        reserve(v, (v.capacity + 1) * 2);
    }

    v.data[v.size] = val;
    v.size++;
}

void pop_back(vector& v) {
    v.size--;
}

size_t size(const vector& v) {
    return v.size;
}

size_t capacity(const vector& v) {
    return v.capacity;
}

void clear(vector& v) {
    v.size = 0;
}

double& at(vector& v, size_t i) {
    return v.data[i];
}

double at(const vector& v, size_t i) {
    return v.data[i];
}

void resize(vector& v, size_t size, double value) {
    reserve(v, size);

    for (size_t i = v.size; i < size; ++i) {
        v.data[i] = value;
    }

    v.size = size;
}

void resize(vector& v, size_t size) {
    resize(v, size, 0);
}

void multiply_all(vector& v, double factor) {
    for (size_t i = 0; i < size(v); i++) {
        at(v, i) *= factor;
    }
}

double accumulate(const vector& v) {
    double sum = 0;

    for (size_t i = 0; i < size(v); i++) {
        sum += at(v, i);
    }

    return sum;
}

int main() {
    const double staticArr[3] = { 1.23, 2.34, 3.45 };
    double* dynamicArr = new double[3]{};
    copy_array(staticArr, dynamicArr, 3);
    print_array(staticArr, 3);  // vypíše: 1.23 2.34 3.45
    print_array(dynamicArr, 3); // vypíše: 1.23 2.34 3.45
    delete[] dynamicArr;

    double* arr = new double[3];
    arr[0] = 1.23;
    arr[1] = 2.34;
    arr[2] = 3.45;
    resize_array(arr, 3, 5);
    arr[3] = 4.56;
    arr[4] = 5.67;
    resize_array(arr, 5, 6);
    arr[5] = 6.78;
    print_array(arr, 6); // vypíše: 1.23 2.34 3.45 4.56 5.67 6.78
    delete[] arr;

    vector v;
    push_back(v, 1.23);
    push_back(v, 2.34);
    push_back(v, 3.45);
    print_vector(v);            // capacity: 6 size: 3 data: 1.23 2.34 3.45
    multiply_all(v, 2);
    print_vector(v);            // capacity: 6 size: 3 data: 2.46 4.68 6.9
    double sum = accumulate(v);
    std::cout << sum << '\n';   // 14.04
    dispose(v);
}

