#include "image.hpp"
#include "timer.hpp"
#include <iostream>
#include <string>

int main(int argc, char** argv) {
    if (argc < 3) return 1;
    double low = std::stoi(argv[1]);
    double high = std::stoi(argv[2]);
    Image in = loadImage("in.png");
    
    Image out;
    out.data.resize(in.data.size());
    out.width = in.width;
    out.height = in.height;

    auto startTime = timer::now();

    for (int retry = 0; retry < 1000; retry++) {
        unsigned char table[256];
        for (int i = 0; i < 256; i++) {
            double res = 256.0 * (static_cast<double>(i) - low) / (high - low);
            if (res < 0) res = 0;
            if (res > 255) res = 255;
            table[i] = static_cast<unsigned char>(res);
        }

        for (int i = 0, sz = in.data.size(); i < sz; i += 4) {
            out.data[i + 0] = table[in.data[i + 0]];
            out.data[i + 1] = table[in.data[i + 1]];
            out.data[i + 2] = table[in.data[i + 2]];
            out.data[i + 3] = in.data[i + 3];
        }
    }

    std::cout << timer::to_ms(timer::now() - startTime) << " ms\n";
    saveImage(out, "out.png");
}
