#ifndef TIMER_HPP
#define TIMER_HPP

#include <chrono>

namespace timer {

    std::chrono::high_resolution_clock::time_point now() {
        return std::chrono::high_resolution_clock::now();
    }

    template <typename TimePoint>
    long long to_ms(TimePoint tp) {
        return std::chrono::duration_cast<std::chrono::milliseconds>(tp).count();
    }

}

#endif
