#include "image.hpp"
#include "lodepng.h"
#include <stdexcept>

Image loadImage(const std::string& filename) {
    Image im;
    auto error = lodepng::decode(im.data, im.width, im.height, filename);
    if (error) throw std::runtime_error("loadImage() failed");
    return im;
}

void saveImage(const Image& image, const std::string& filename) {
    auto error = lodepng::encode(filename, image.data, image.width, image.height);
    if (error) throw std::runtime_error("saveImage() failed");
}
