#include <queue>
#include <mutex>
#include <thread>
#include <iostream>
#include <string>
#include <mutex>

template<class T>
class synchronized {
public:
    synchronized(const T& t) : m_t(t) {}

    template<typename F>
    auto operator()(F f) {
        std::lock_guard<std::mutex> l{ m_mutex };
        return f(m_t);
    }

private:
    T m_t;
    std::mutex m_mutex;
};

int main() {
    synchronized<std::ostream&> locked_cout(std::cout);
    auto thread_func = [&] (std::string s) {
        for (int i = 0; i < 1'000; ++i) {
            locked_cout([&] (std::ostream& out) {
                out << "Ahoj z vlakna " << s << '\n';
            });
        }
    };

    std::vector<std::thread> threads;
    for (int i = 0; i < 4; ++i) {
        threads.emplace_back(thread_func, std::to_string(i));
    }

    for (auto& t : threads) {
        t.join();
    }
}
