#include <queue>
#include <mutex>
#include <condition_variable>
#include <thread>
#include <iostream>
#include <chrono>

template <typename T>
class blocking_queue {
public:
    bool add(T const& e) {
        std::unique_lock<std::mutex> lg(mutex);
        if (closing) {
            return false;
        }
        queue.push(e);
        cvar.notify_one();
        return true;
    }

    std::pair<bool, T> take() {
        std::unique_lock<std::mutex> lg(mutex);
        cvar.wait(lg, [&] () -> bool { return queue.size() > 0 || closing; });
        if (queue.size() == 0) {
            return { false, T{} };
        }
        auto out = std::move(queue.front()); queue.pop();
        return { true, std::move(out) };
    }

    void close() {
        std::unique_lock<std::mutex> lg(mutex);
        closing = true;
        cvar.notify_all();
    }


private:
    std::queue<T> queue;
    std::mutex mutex;
    std::condition_variable cvar;
    bool closing = false;
};

int main() {
    using namespace std::chrono_literals;
    blocking_queue<int> queue;
    auto producer = [] (blocking_queue<int>& queue) {
        for (int i = 0; i < 100; ++i) {
            queue.add(i);
            std::this_thread::sleep_for(100ms);
        }
        queue.close();
    };

    auto consumer = [] (blocking_queue<int>& queue) {
        while (true) {
            auto elem = queue.take();
            if (!elem.first) {
                break;
            }
            std::cout << elem.second << '\n';
        }
    };

    std::thread t1(producer, std::ref(queue));
    std::thread t2(consumer, std::ref(queue));

    t1.join();
    t2.join();
}
