#include <queue>
#include <mutex>
#include <condition_variable>
#include <thread>
#include <iostream>
#include <chrono>

template <typename T>
class blocking_queue {
public:
    void add(T const& e) {
        std::unique_lock<std::mutex> lg(mutex);
        queue.push(e);
        cvar.notify_one();
    }

    T take() {
        std::unique_lock<std::mutex> lg(mutex);
        cvar.wait(lg, [&] () -> bool { return queue.size() > 0; });
        auto out = std::move(queue.front()); queue.pop();
        return out;
    }

private:
    std::queue<T> queue;
    std::mutex mutex;
    std::condition_variable cvar;
};

int main() {
    using namespace std::chrono_literals;
    blocking_queue<int> queue;
    auto producer = [] (blocking_queue<int>& queue) {
        for (int i = 0; i < 100; ++i) {
            queue.add(i);
            std::this_thread::sleep_for(100ms);
        }
    };

    auto consumer = [] (blocking_queue<int>& queue) {
        while (true) {
            auto elem = queue.take();
            std::cout << elem << '\n';
        }
    };

    std::thread t1(producer, std::ref(queue));
    std::thread t2(consumer, std::ref(queue));

    t1.join();
    t2.join();
}
