#include <thread>
#include <iostream>
#include <mutex>
#include <vector>

class atomic_counter {
public:
    int value() {
        std::unique_lock<std::mutex> l(m_mutex);
        return m_counter;
    }
    
    template <typename T>
    auto with(T function) {
        std::unique_lock<std::mutex> l(m_mutex);
        return function(m_counter);
    }
    
private:
    int m_counter = 0;
    std::mutex m_mutex;
};

int main() {
    for (int i = 0; i < 1000000; ++i) {
        atomic_counter counter;

        auto thread_func = [&counter]() {
            while (counter.with([](int& c) {
                if (c < 5) {
                    c++;
                    return true;
                }
                return false;
            })) {
                // do something
            }
        };

        std::vector<std::thread> threads;
        for (int i = 0; i < 4; ++i) {
            threads.emplace_back(thread_func);
        }
        for (auto& thread : threads) {
            thread.join();
        }

        if (counter.value() != 5) {
            std::cout << counter.value() << '\n';
        }
    }
}
