#include <queue>
#include <mutex>
#include <thread>
#include <iostream>
#include <string>
#include <mutex>
#include <future>

template <typename T>
class blocking_queue {
public:
    void add(T const& e) {
        std::unique_lock<std::mutex> lg(mutex);
        queue.push(e);
        cvar.notify_one();
    }

    T take() {
        std::unique_lock<std::mutex> lg(mutex);
        cvar.wait(lg, [&] () -> bool { return queue.size() > 0; });
        auto out = std::move(queue.front()); queue.pop();
        return out;
    }

private:
    std::queue<T> queue;
    std::mutex mutex;
    std::condition_variable cvar;
};


template<typename Fut, typename F, typename T>
void set_value(std::promise<Fut>& p, F& f, T& t) { p.set_value(f(t)); }
template<typename F, typename T>
void set_value(std::promise<void>& p, F& f, T& t) { f(t); p.set_value(); }

template <typename T>
class concurrent {
    T t;
    blocking_queue<std::function<void()>> q;
    bool done = false;
    std::thread thd;
public:
    explicit concurrent(T const& t):
        t(t),
        thd([=] () {while (!done) q.take()(); })
    {}
    ~concurrent() { q.add([=] () { done = true; }); thd.join(); }


    template <typename F>
    auto operator()(F f) -> std::future<decltype(f(t))> {
        auto p = std::make_shared<std::promise<decltype(f(t))>>();
        auto ret = p->get_future();

        q.add([=] () {
            try {
                set_value(*p, f, t);
            } catch (...) {
                p->set_exception(std::current_exception());
            }
        });
        return ret;
    }
};


int main() {
    concurrent<std::string> s("start");
    auto prom = s([](std::string& s) {
        s += "\n";
        s += "The answer is: " + std::to_string(42);
    });
    std::cout << s([] (std::string& s) { return s; }).get() << '\n';
}
