#ifndef VECTOR_HPP_INCLUDED
#define VECTOR_HPP_INCLUDED

#include <cstddef>
#include <memory>
#include <iosfwd>
#include <iterator>

using std::size_t;

class vector {
public:
    vector();

    vector(const vector& rhs);
    vector& operator=(const vector& rhs);

    void reserve(size_t cap);
    void push_back(double val);
    void pop_back();
    size_t size() const;
    size_t capacity() const;
    void clear();
    void swap(vector& rhs);

    double& operator[](size_t i);
    double operator[](size_t i) const;

    using iterator = double*;
    using const_iterator = const double*;

    iterator begin() { return iterator(m_data.get()); }
    iterator end() { return iterator(m_data.get() + m_size); }
    const_iterator begin() const { return const_iterator(m_data.get()); }
    const_iterator end() const { return const_iterator(m_data.get() + m_size); }

private:
    std::unique_ptr<double[]> m_data;
    size_t m_capacity;
    size_t m_size;
};

std::ostream& operator<<(std::ostream& out, const vector& v);

#endif
