#include "vector.hpp"
#include "array.hpp"
#include <iostream>

vector::vector():
    m_data(nullptr),
    m_capacity(0),
    m_size(0) {}

vector::vector(const vector& rhs) :
    m_data(std::make_unique<double[]>(rhs.m_size)),
    m_capacity(rhs.m_capacity),
    m_size(rhs.m_size) {
    copy_array(rhs.m_data.get(), m_data.get(), m_size);
}

vector& vector::operator=(const vector& rhs) {
    vector temp(rhs);
    swap(temp);
    return *this;
}

void vector::reserve(size_t cap) {
    if (m_capacity < cap) {
        resize_array(m_data, m_size, cap);
        m_capacity = cap;
    }
}

void vector::push_back(double val) {
    if (m_size == m_capacity) {
        reserve((m_capacity + 1) * 2);
    }

    m_data[m_size] = val;
    m_size++;
}

void vector::pop_back() {
    m_size--;
}

size_t vector::size() const {
    return m_size;
}

size_t vector::capacity() const {
    return m_capacity;
}

void vector::clear() {
    m_size = 0;
}

double& vector::operator[](size_t i) {
    return m_data[i];
}

double vector::operator[](size_t i) const {
    return m_data[i];
}

void vector::swap(vector& rhs) {
    std::swap(m_data, rhs.m_data);
    std::swap(m_capacity, rhs.m_capacity);
    std::swap(m_size, rhs.m_size);
}

std::ostream& operator<<(std::ostream& out, const vector& v) {
    out << '(';
    if (v.size() != 0) {
        out << v[0];
    }
    for (size_t i = 1; i < v.size(); i++) {
        out << ", " << v[i];
    }
    return out << ')';
}
