#pragma once

#include "CoreMinimal.h"
#include "BehaviorTree/BTTaskNode.h"
#include "BTTask_SelectRandomObject.generated.h"

/**
 * A simple Behavior Tree
 */
UCLASS()
class CV10_API UBTTask_SelectRandomObject : public UBTTaskNode
{
	GENERATED_BODY()
	UBTTask_SelectRandomObject(const FObjectInitializer& ObjectInitializer);

	virtual EBTNodeResult::Type ExecuteTask(UBehaviorTreeComponent& OwnerComp, uint8* NodeMemory) override;

protected:
	UPROPERTY(EditAnywhere, Category="Filter")
	TSubclassOf<AActor> TargetClass;
	
	UPROPERTY(EditAnywhere, Category="Blackboard")
	struct FBlackboardKeySelector ObjectBlackboardKey;
	
	UPROPERTY(EditAnywhere, Category="Blackboard")
	struct FBlackboardKeySelector LocationBlackboardKey;
	
};
