#pragma once

#include "CoreMinimal.h"
#include "BehaviorTree/Services/BTService_BlackboardBase.h"
#include "BTService_MentalState.generated.h"

/**
 * 
 */
UCLASS()
class CV10_API UBTService_MentalState : public UBTService
{
	GENERATED_BODY()

	UBTService_MentalState(const FObjectInitializer& ObjectInitializer);

	virtual void TickNode(UBehaviorTreeComponent& OwnerComp, uint8* NodeMemory, float DeltaSeconds) override;

protected:
	UPROPERTY(EditAnywhere, Category="Blackboard")
	struct FBlackboardKeySelector BoredomBlackboardKey;
	
	UPROPERTY(EditAnywhere, Category="Blackboard")
	struct FBlackboardKeySelector PanicBlackboardKey;
};
