#include "BTTask_ChangeMoveSpeed.h"

#include "AIController.h"
#include "GameFramework/CharacterMovementComponent.h"
#include "GameFramework/PawnMovementComponent.h"


UBTTask_ChangeMoveSpeed::UBTTask_ChangeMoveSpeed(const FObjectInitializer& ObjectInitializer) : Super(ObjectInitializer)
{
	NodeName = "Change Movement Speed";
	INIT_TASK_NODE_NOTIFY_FLAGS();
}

EBTNodeResult::Type UBTTask_ChangeMoveSpeed::ExecuteTask(UBehaviorTreeComponent& OwnerComp, uint8* NodeMemory)
{
	UCharacterMovementComponent* MovementComponent = Cast<UCharacterMovementComponent>(OwnerComp.GetAIOwner()->GetPawn()->GetComponentByClass(UCharacterMovementComponent::StaticClass()));
	
	if (MovementComponent)
	{
		MovementComponent->MaxWalkSpeed = MovementSpeed;
	}

	return EBTNodeResult::Succeeded;
}
