#include "BTService_MentalState.h"

#include "AIController.h"
#include "BehaviorTree/BlackboardComponent.h"
#include "Perception/AIPerceptionComponent.h"
#include "Perception/AIPerceptionTypes.h"
#include "Perception/AISenseConfig.h"


UBTService_MentalState::UBTService_MentalState(const FObjectInitializer& ObjectInitializer) : Super(ObjectInitializer)
{
	NodeName = "Mental State";

	// Make sure out tick function gets called.
	INIT_SERVICE_NODE_NOTIFY_FLAGS();

	// Set filters for our blackboard keys
	PanicBlackboardKey.AddFloatFilter(this, GET_MEMBER_NAME_CHECKED(UBTService_MentalState, PanicBlackboardKey));
	BoredomBlackboardKey.AddFloatFilter(this, GET_MEMBER_NAME_CHECKED(UBTService_MentalState, BoredomBlackboardKey));
}

void UBTService_MentalState::TickNode(UBehaviorTreeComponent& OwnerComp, uint8* NodeMemory, float DeltaSeconds)
{
	Super::TickNode(OwnerComp, NodeMemory, DeltaSeconds);

	TObjectPtr<UAIPerceptionComponent> AIPerception = Cast<UAIPerceptionComponent>(OwnerComp.GetAIOwner()->GetComponentByClass(UAIPerceptionComponent::StaticClass()));
	UBlackboardComponent* BlackboardComponent = OwnerComp.GetBlackboardComponent();

	// Current values from the blackboard. Don't forget to save them again using SetValueAsFloat.
	float Panic = BlackboardComponent->GetValueAsFloat(PanicBlackboardKey.SelectedKeyName);
	float Boredom = BlackboardComponent->GetValueAsFloat(BoredomBlackboardKey.SelectedKeyName);

	// TODO: Accumulate boredom and panic when appropriate. Panic should accumulate when there is a stimulus close by,
	// since in our setup the only stimulus is an explostion, which should cause panic.

	if (AIPerception)
	{
		// Get first AI sense and the last trace it detected.
		FAISenseID SenseID = (*AIPerception->GetSensesConfigIterator())->GetSenseID();
		const FActorPerceptionInfo* ActorPerceptionInfo = AIPerception->GetFreshestTrace(SenseID);
		
		// TODO: If the source is close enough, we should (maybe slowly) start panicking.
	}
}
