
#pragma once

#include "CoreMinimal.h"
#include "Components/ActorComponent.h"
#include "Components/PoseableMeshComponent.h"
#include "FABRIKComponent.generated.h"

struct FBoneChainLink
{
	FName BoneName;
	double BoneDistance;
};


UCLASS( ClassGroup=(Custom), meta=(BlueprintSpawnableComponent) )
class CV09_API UFABRIKComponent : public UActorComponent
{
	GENERATED_BODY()

public:	
	UFABRIKComponent();

	// Computes a single iteration of the FABRIK algorithm. It is then used repeatedly in a cycle
	// to achieve the desired pose precision.
	UFUNCTION(BlueprintCallable, CallInEditor, Category="FABRIK")
	void FABRIKSingleIteration();

	// Specifies which bone will be the effector and the and of the IK chain.
	UPROPERTY(BlueprintReadOnly, EditAnywhere, Category="FABRIK")
	FName BoneChainEnd;

	// How long the IK chain should be.
	UPROPERTY(BlueprintReadOnly, EditAnywhere, Category="FABRIK")
	int BoneChainLength;

	// Tolerance in meters how close the effector has to be to the target for the pose
	// to count as done.
	UPROPERTY(BlueprintReadWrite, EditAnywhere, Category="FABRIK")
	double TargetDistanceTolerance = 0.1;

	// Maximum number of FABRIK iterations in case we don't reach the desired tolerance
	// sooner.
	UPROPERTY(BlueprintReadWrite, EditAnywhere, Category="FABRIK")
	int MaxIterations = 10;

	// Who to follow with our affector.
	UPROPERTY(BlueprintReadWrite, EditAnywhere, Transient, Category="FABRIK")
	TObjectPtr<AActor> Target;

	// Whether FABRIK is enabled.
	UPROPERTY(BlueprintReadWrite, EditAnywhere, Category="FABRIK")
	bool EnableFABRIK = true;
	
protected:
	virtual void BeginPlay() override;
	bool IsTargetReachable();
	void FixRotations();

	TArray<FBoneChainLink> BoneChain;
	
	UPROPERTY()
	UPoseableMeshComponent* PoseableMesh;
public:
	virtual void TickComponent(float DeltaTime, ELevelTick TickType, FActorComponentTickFunction* ThisTickFunction) override;
};
