#pragma once

#include "CoreMinimal.h"

class FClothSpring;
typedef TSharedRef<FClothSpring> FClothSpringRef;

/**
 * This class represents a cloth mass point, bearing some position, current speed and force
 * which is acting on this node.
 */
class CV06_API FClothNode
{
public:
	FClothNode(const FVector& Position, const double Mass = 1.0) : Position(Position), Mass(Mass) {}
	~FClothNode() {}

	void Tick(float DeltaTime, UWorld* World, const FTransform& ParentTransform);

	// Set whether the node is able to move - fixed node has forced zero speed.
	void SetFixed(bool bInFixed);

	// Reset the acting force vector to zero.
	void ClearForce();

	// Adds a singular force value to be included when ticking. Use after RecalculateForce.
	void AddForce(const FVector& InForce);
	
	FVector GetPosition() const;
	FVector GetSpeed() const;
	
private:
	FVector Position;
	const double Mass = 1.0;
	bool bFixed = false;

	FVector Speed = FVector::ZeroVector;
	FVector ActingForce = FVector::ZeroVector;
	
	// Modifies the speed as a result of sphere collision.
	void ChangeSpeedAccordingToIntersectedSphere(const FVector& IntersectionPoint, const FVector& NodePosition);

	// Simple point-sphere intersection check. Returns true if intersecting.
	bool TestSphereIntersection(const FVector& Location, float Radius) const;
};
