#pragma once

#include "CoreMinimal.h"
#include "UObject/Interface.h"
#include "ClothInteractionObject.generated.h"

// This class does not need to be modified.
UINTERFACE(MinimalAPI)
class UClothInteractionObject : public UInterface
{
	GENERATED_BODY()
};

/**
 * Interface which an actor must implement to be able to interact with the
 * simulated cloth.
 */
class CV06_API IClothInteractionObject
{
	GENERATED_BODY()

	// Add interface functions to this class. This is the class that will be inherited to implement this interface.
public:
	UFUNCTION(BlueprintCallable, BlueprintNativeEvent)
	double GetSphereRadius();
	virtual double GetSphereRadius_Implementation();

	UFUNCTION(BlueprintCallable, BlueprintNativeEvent)
	FVector GetWorldPosition();
	virtual FVector GetWorldPosition_Implementation();
};
