db.actors.drop();
db.movies.drop();

db.createCollection("actors");
db.actors.insertMany([
  {
    _id: "trojan",
    name: { first: "Ivan", last: "Trojan" }, year: 1964,
    movies: [ "samotari", "medvidek", "karamazovi" ]
  },
  {
    _id: "machacek",
    name: { first: "Jiri", last: "Machacek" }, year: 1966,
    movies: [ "medvidek", "vratnelahve", "samotari" ]
  },
  {
    _id: "schneiderova",
    name: { first: "Jitka", last: "Schneiderova" }, year: 1973,
    movies: [ "samotari" ]
  },
  {
    _id: "sverak",
    name: { first: "Zdenek", last: "Sverak" }, year: 1936,
    movies: [ "vratnelahve" ]
  },
  {
    _id: "geislerova",
    name: { first: "Anna", last: "Geislerova" }, year: 1976
  },
  {
    _id: "vilhelmova",
    name: { first: "Tatiana", last: "Vilhelmova" }, year: 1978,
    movies: [ "medvidek" ]
  },
  {
    _id: "menzel",
    name: { last: "Menzel", first: "Jiri" }, year: 1938,
    movies: "medvidek"
  }
]);

db.createCollection("movies");
db.movies.insertMany([
  {
    _id: "samotari",
    title: { cs: "Samotari", en: "Loners" },
    year: 2000, rating: 84,
    actors: [ "trojan", "machacek", "schneiderova" ],
    genres: [ "comedy", "drama" ], country: [ "CZ", "SI" ], length: 103
  },
  {
    _id: "medvidek",
    title: "Medvidek",
    year: 2007, director: { first: "Jan", last: "Hrebejk" }, rating: 53,
    actors: [ "trojan", "machacek", "vilhelmova", "issova", "menzel" ],
    genres: [ "comedy", "drama" ], country: [ "CZ" ], length: 100
  },
  {
    _id: "vratnelahve",
    title: { cs: "Vratne lahve", en: "Empties" },
    year: 2006, director: { first: "Jan", last: "Sverak" }, rating: 76,
    actors: [ "sverak", "machacek", "schneiderova" ],
    genres: "comedy", country: "CZ", length: 99
  },
  {
    _id: "zelary",
    title: "Zelary",
    year: 2003, director: { last: "Trojan", first: "Ondrej" }, rating: 81,
    actors: [ ],
    genres: [ "romance", "drama" ], country: [ "CZ", "SK", "AT" ], length: 142
  },
  {
    _id: "stesti",
    title: "Stesti",
    year: 2005, director: { last: "Slama", first: "Bohdan" }, rating: 72,
    length: 100,
    awards: [
      { type: "Czech Lion", year: 2005 }
    ]
  },
  {
    _id: "kolja",
    title: "Kolja",
    year: 1996, rating: 86,
    length: 105,
    awards: [
      { type: "Czech Lion", year: 1996 },
      { type: "Noname Awards", category: "A", year: 2005 }
    ]
  }
]);

//Verify:
db.actors.countDocuments();
db.movies.countDocuments();
db.actors.findOne({ _id: "machacek" });
db.movies.findOne({ _id: "samotari" });

//Optimization 1
db.movies.explain("executionStats")
  .find({ year: { $gte: 2000 } }, { _id: 1, year: 1, rating: 1 })
  .sort({ rating: -1 })
  .limit(3);

db.movies.createIndex({ rating: -1, year: 1 });

db.movies.explain("executionStats")
  .find({ year: { $gte: 2000 } }, { _id: 1, year: 1, rating: 1 })
  .sort({ rating: -1 })
  .limit(3);


//Optimization2
db.movies.explain("executionStats")
  .find({ actors: "machacek" }, { _id: 1, year: 1, rating: 1 })
  .sort({ year: -1 });

db.movies.createIndex({ actors: 1, year: -1 });

db.movies.explain("executionStats")
  .find({ actors: "machacek" }, { _id: 1, year: 1, rating: 1 })
  .sort({ year: -1 });

//Optimization3
db.movies.explain("executionStats")
  .find({ "awards.type": "Czech Lion" }, { _id: 1, year: 1, "awards.$": 1 })
  .sort({ year: -1 });

db.movies.createIndex({ "awards.type": 1, year: -1 });

db.movies.explain("executionStats")
  .find({ "awards.type": "Czech Lion" }, { _id: 1, year: 1, "awards.$": 1 })
  .sort({ year: -1 });

  