def sum_digits(text: str) -> int:
    """Return the sum of all digits in the text
    
    >>> text = ""
    >>> sum_digits(text)
    0
    >>> sum_digits("123")
    6
    """
    return sum(int(char) for char in text if char in "123456789")

if __name__=="__main__":
    import doctest
    doctest.testmod(verbose=True)