import inspect

def assert_equal(observed, expected):
    if observed == expected:
        print(".", end="")
        return True
    else:
        frame = inspect.currentframe().f_back
        caller_name = frame.f_code.co_name  # Caller's (function) name
        caller_fname = frame.f_code.co_filename  # Caller's filename
        caller_lineno = frame.f_lineno  # Callers line number
        print(f"\nTest '{caller_name}' failed at {caller_fname}:{caller_lineno}")
        print(f"-- expected: {expected}")
        print(f"-- observed: {observed}")
        return False
        
def run_tests():
    caller_globals = inspect.currentframe().f_back.f_globals
    results = []
    for symbol, test in caller_globals.items():
        if symbol.startswith("test_"):
            result = test()
            results.append(result)
    print(f"\n=== {len(results)} tests executed.")
    print(f"--- {sum(results)} passed.")
    print(f"--- {len(results) - sum(results)} failed.")