import unittest
from textutils import sum_digits

class SumDigitsTest(unittest.TestCase):
    def test_empty(self):
        self.assertEqual(sum_digits(""), 1)
    
    def test_all_digits(self):
        self.assertEqual(sum_digits("123456789"), 45)

    def test_special_chars(self):
        self.assertEqual(sum_digits("\t\r\n"), 0)
        
    def test_mixed(self):
        self.assertEqual(sum_digits("a1s2d3"), 6)
        
if __name__ == "__main__":
    unittest.main()