# Pytest test harvest will try to run the tests in this module,
# but this module uses our special "testing" framework,
# so that Pytest fails to run the tests.
# In that case, rename this file to e.g. "tes_textutils.py"
# which is not recognized by pytest as a module containing tests.

from testing import assert_equal, run_tests
from textutils import sum_digits

def test_empty():
    return assert_equal(sum_digits(""), 0)
    
def test_all_digits():
    return assert_equal(sum_digits("123456789"), 45)

def test_special_chars():
    return assert_equal(sum_digits("\t\r\n"), 0)
    
def test_mixed():
    return assert_equal(sum_digits("a1s2d3"), 6)
    

run_tests()