import unittest
from rosemary import Item, update


class RosemaryTest(unittest.TestCase):
    def test_name_does_not_change(self):
        item = Item("foo", 0, 0)
        update(item)
        self.assertEqual("foo", item.name)

    def test_normal_item(self):
        item = Item("A normal item", days_left=1, quality=21)
        update(item)
        self.assertEqual(0, item.days_left)
        self.assertEqual(20, item.quality)

    def test_normal_item_quality_degrades_twice_as_fast_after_expiration(self):
        item = Item("A normal item", days_left=0, quality=21)
        update(item)
        self.assertEqual(19, item.quality)

    def test_normal_item_quality_isnt_negative(self):
        item = Item("A normal item", days_left=5, quality=0)
        update(item)
        self.assertEqual(0, item.quality)

    def test_diamonds_quality_stays_at_100(self):
        item = Item("Diamonds", days_left=10, quality=100)
        update(item)
        self.assertEqual(100, item.quality)

    def test_diamonds_past_date(self):
        item = Item("Diamonds", days_left=-3, quality=100)
        update(item)
        self.assertEqual(100, item.quality)

    def test_aged_brie_quality_increases(self):
        item = Item("Aged Brie", days_left=30, quality=25)
        update(item)
        self.assertEqual(26, item.quality)
        self.assertEqual(29, item.days_left)

    def test_aged_brie_hits_50(self):
        item = Item("Aged Brie", days_left=30, quality=50)
        update(item)
        self.assertEqual(50, item.quality)

    def test_tickets_increase_quality(self):
        item = Item("Tickets", days_left=27, quality=30)
        update(item)
        self.assertEqual(31, item.quality)

    def test_tickets_quality_hits_50(self):
        item = Item("Tickets", days_left=30, quality=50)
        update(item)
        self.assertEqual(50, item.quality)

    def test_tickets_10_or_less_days_left(self):
        item = Item("Tickets", days_left=10, quality=23)
        update(item)
        self.assertEqual(25, item.quality)

    def test_tickets_5_or_less_days_left(self):
        item = Item("Tickets", days_left=5, quality=41)
        update(item)
        self.assertEqual(44, item.quality)

    def test_tickets_less_0_or_less_days(self):
        item = Item("Tickets", days_left=0, quality=41)
        update(item)
        self.assertEqual(0, item.quality)


if __name__ == "__main__":
    unittest.main()
