class Item:
    def __init__(self, name, days_left, quality):
        self.name = name
        self.days_left = days_left
        self.quality = quality


MIN_QUALITY = 0
MAX_QUALITY = 50


def update_diamonds(item):
    pass


def update_normal(item):
    decrease_quality(item)
    item.days_left -= 1
    if item.days_left < 0:
        decrease_quality(item)


def update_tickets(item):
    increase_quality(item)
    if item.days_left <= 10:
        increase_quality(item)
    if item.days_left <= 5:
        increase_quality(item)
    item.days_left -= 1
    if item.days_left < 0:
        item.quality = 0


def update_brie(item):
    increase_quality(item)
    item.days_left -= 1
    if item.days_left < 0:
        increase_quality(item)


def decrease_quality(item):
    if item.quality > MIN_QUALITY:
        item.quality -= 1


def increase_quality(item):
    if item.quality < MAX_QUALITY:
        item.quality += 1


UPDATERS = {
    "Diamonds": update_diamonds,
    "Aged Brie": update_brie,
    "Tickets": update_tickets,
}


def update(item):
    # if item.name == "Diamonds":
    #     update_diamonds(item)
    # elif item.name == "Aged Brie":
    #     update_brie(item)
    # elif item.name == "Tickets":
    #     update_tickets(item)
    # else:
    #     update_normal(item)
    update_func = UPDATERS.get(item.name, update_normal)
    update_func(item)
