# Refactoring
Codes used on 2025-11-25 for refactoring lecture.

## Rosemary
* test_rosemary.py - Tests for update function (similir to those you created during labs a week ago)
* rosemary_0.py - The initial version of update function
* rosemary_lecture.py - The refactored version of update function in a state after the lecture

## Fitness Tracker
* fitness_0.py - The initial version of the fitness tracker. Everything in a class, long methods, ...
* fitness_lecture.py - The refactored version of the fitness tracker in a state after the lecture. Class removed, methods turned into ordinary functions, long functions decomposed to shorter ones.
* fitness_final.py - Further refactorings, how far we could go. Introduce Entry data class, that can parse a CSV line, and export itself to CSV string; load_entries as a generator function, reads all food and activity entries (not just the calories from a particular day); ...
* test_fitness.py - Test for the fitness tracker.

Here, the emphasis is more on the creation of the test(s) that then allow us to refactor the code with confidence. It demonstrates:
* how to use capsys fixture from pytest to capture the standard output of a function;
* how to use syrupy extension for pytest to do snapshot testing. Just "pytest" compares the current captured output to the stored snapshot. Running "pytest --snapshot-update" updates the stored snapshot to the current output.

For the snapshot testing with Syrupy, you need to install the syrupy package (and pytest if not already installed):
```
pip install syrupy  # or
pip install pytest syrupy
```