# Multilayer Network Diagnostics
## Hierarchical Multilayer Model – Assignment

### Context
In model-based testing, a system is represented as a **hierarchical multilayer network**.
Each layer models the system at a different abstraction level and may contain **different components**.

Inter-layer relations represent **traceability** between components of adjacent layers and enable end-to-end testing.

---

## Model Definition

A hierarchical multilayer test model consists of:
- An ordered set of layers (from lowest to highest)
- A distinct set of components for each layer
- Intralayer relations (relations inside one layer)
- Interlayer projections between components of neighboring layers

---

## Task 1 – Multilayer Test Model (0.2)

Implement a class representing a hierarchical multilayer test model.

The model must:
1. Support an arbitrary number of ordered layers
2. Allow each layer to contain its own components
3. Support intralayer relations inside each layer
4. Support interlayer projections between neighboring layers

---

## Task 2 – Test Requirements (0.2)

Define the following test requirements:

### R1 – Component Coverage
Each component must participate in at least one intralayer relation within its own layer.

### R2 – Intralayer Coverage
Each layer must contain at least one intralayer relation.

### R3 – Cross-Layer Traceability
Each component in a higher layer must have at least one projection to a component in the layer directly below.

---

## Task 3 – Diagnostics (0.2)

Implement diagnostic functions that verify whether requirements R1, R2, and R3 are satisfied.

The diagnostics must return a Boolean result for each requirement.

---

## Task 4 – Test Path Generation (0.2)

Implement a function that generates **end-to-end paths** in a hierarchical multilayer test model.

The function must find all existing paths from all components in a selected higher layer to all components in the lowest layer, if such paths exist.

Each path:
- Starts at a component in the selected higher layer,
- may traverse intralayer relations within a layer,
- traverses interlayer projections only downward between layers,
- ends at a component in the lowest layer.

Each path represents a potential end-to-end test case derived from the multilayer model.

---

## Task 5 – Fault Injection (0.2)

Introduce one fault into the model:
- remove an intralayer relation, or
- remove an interlayer projection

Re-run the diagnostics and explain:
- which test requirement fails
- why the model becomes non-testable

---

## Expected Outcome

You should understand:
- how different abstraction levels are modeled using layers
- how traceability enables end-to-end testing
- how model diagnostics reveal missing or invalid tests
