#include "crypto.h"
#include "ui_crypto.h"

#include <QDateTime>

#include <QtCharts/QLineSeries>
#include <QtCharts/QDateTimeAxis>
#include <QtCharts/QValueAxis>

#include <QtNetwork/QNetworkAccessManager>
#include <QtNetwork/QNetworkReply>
#include <QtNetwork/QNetworkRequest>
#include <QEventLoop>

// TODO:
// Pridat hlavickove soubory pro Json
// Pridat hlavickove soubory pro SQL databazi a do projektu knihovnu sql
// V UI dodelat vzhled formulare

crypto::crypto(QWidget *parent)
    : QMainWindow(parent)
    , ui(new Ui::crypto)
{
    ui->setupUi(this);

    this->tmr.setInterval(1000);
    QObject::connect(&this->tmr, &QTimer::timeout, this, &crypto::fetchData);
    this->tmr.start();

    this->loadDB();
    this->drawChart();

    qDebug() << "APP Start";
}

void crypto::loadDB(void){
    // TODO:
    // Vytvoreni DB
    // Vytvoreni tabulky krypto
    // Test ulozeni a nacteni dat
    // Zobrazit data pres qDebug()
}

crypto::~crypto()
{
    delete ui;
}

void crypto::fetchData(void){
    QNetworkAccessManager *mgr = new QNetworkAccessManager;
    QNetworkRequest req(QUrl("https://min-api.cryptocompare.com/data/price?fsym=BTC&tsyms=USD,EUR"));
    QNetworkReply *reply = mgr->get(req);

    QEventLoop eventLoop;
    QObject::connect(mgr, &QNetworkAccessManager::finished, &eventLoop, &QEventLoop::quit);
    eventLoop.exec();

    if(reply->error() != QNetworkReply::NoError){
        qDebug() << "Error during fetchData";
        return;
    }

    // TODO: naparsovat data z JSON
}

void crypto::drawChart(void){

    int             noPoints = 50;
    QLineSeries     *data    = new QLineSeries();
    data->setName("Mena");

    QDateTime       timeMin  = QDateTime::currentDateTime();
    for (int i = 0; i < noPoints; ++i) {
        // TODO: nacist data z DB a zobrazit je
        QDateTime time = timeMin.addSecs(i *5);     // krok 5 vterin
        double value = 15 + qSin(i / 3.0) * 5;              // sinusovy prubeh
        *data << QPointF(time.toMSecsSinceEpoch(), value);
    }

    // vytvoreni grafu
    QChart *chart = new QChart();
    chart->setTitle(QString("Historie cen"));
    chart->addSeries(data);

    // nastaveni osy X
    QDateTimeAxis *dateTimeAxis = new QDateTimeAxis;
    chart->addAxis(dateTimeAxis, Qt::AlignBottom);
    data->attachAxis(dateTimeAxis);
    dateTimeAxis->setTickCount(7);
    dateTimeAxis->setFormat("hh:mm");
    dateTimeAxis->setTitleText("Datum");

    // nastaveni osy Y
    QValueAxis *axisY = new QValueAxis;
    chart->addAxis(axisY, Qt::AlignLeft);
    data->attachAxis(axisY);
    axisY->setTitleText("Cena");

    ui->chartCrypto->setChart(chart);
}
