(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     22135,        446]
NotebookOptionsPosition[     21427,        425]
NotebookOutlinePosition[     21827,        441]
CellTagsIndexPosition[     21784,        438]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"RegionPlot3D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SubscriptBox["x", "1"], "<=", " ", "5"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"4", 
       SubscriptBox["x", "1"]}], "+", 
      SubscriptBox["x", "2"]}], "<=", "25"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"8", 
       SubscriptBox["x", "1"]}], "+", 
      RowBox[{"4", 
       SubscriptBox["x", "2"]}], "+", 
      SubscriptBox["x", "3"]}], "<=", "125"}]}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["x", "1"], ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["x", "2"], ",", "0", ",", "30"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["x", "3"], ",", "0", ",", "130"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Yellow", ",", " ", 
      RowBox[{"Opacity", "[", "0.5", "]"}]}], "]"}]}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.9175978960590143`*^9, 3.9175979091879597`*^9}, {
  3.9175979539576178`*^9, 3.917598118475006*^9}, {3.917598154056816*^9, 
  3.917598155398012*^9}, {3.917598198745779*^9, 3.917598276444777*^9}, {
  3.917598386943665*^9, 3.917598392277217*^9}, {3.91759844180613*^9, 
  3.9175984586985064`*^9}, {3.91759923889886*^9, 3.917599264282551*^9}, {
  3.917599372552618*^9, 3.9175994059563217`*^9}, {3.9175994536508217`*^9, 
  3.917599505094192*^9}},
 CellLabel->"In[55]:=",ExpressionUUID->"1e678bd6-d3dd-4f45-902c-870f474fdfce"],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJyVW0tsHEUQXQcwBBDKWFEEWIIs2CGbEBMPxEFEYkeD+DjLd4EYsvyEwoGP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    "], {{
      {RGBColor[1, 1, 0], Opacity[0.5], EdgeForm[None], 
       StyleBox[GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJwt0jssREEUgOF7r0eDIIh3vJdC4c0qvEIQhKhoSCRodr2CoLZb29UgaBGV
hoaCmgJBEARBEHS0/pM5xZezMztzZ845kzUw2j3iWJbViBBE25YVg1i8MH7F
G+4wCy8e8YRnbLFuFtO22XvD3BUm+T2l83G4Z+4W1/CgX7/jwxwu0IcufOEb
P5a5QwB+LPGdcYzgnfEagrp+E+uWOSseCQjAi2Fd/4FPtDFOQ4pt7tmCJoQi
DOG6N4hFnGIbq/ChFx3YgR9zcPFdF4XMwzPjQxwgkfE+MYmYgiF+pzoml2Ws
wIN61OKX7+xJXRHB+JJ4jgz2HBMziTNaczlX1kQiCmNoRINt1rSjVfM6Y++J
1v9GeyE9lb484BSdqJN6ynocoRnJkgcW+K+U80swaJtcpLZpjN3EdOK89lT6
1cNcgcxL7bRf0qMN7Zfk6LJNrz/1DVzq+5H7nGnuzdojyaUQf/o2duHmzCrH
1NCrb0POKmeuTO9TTCxyTH3k/UzY5g20ax+ld/koQDbrcpHjmHwD+sbkzpXM
VWjuNajGP7BRZOA=
           "]], Polygon3DBox[CompressedData["
1:eJxNlMtLVVEUxs/e3d5aWloZ2vWRaV6rsQX2wMbJ9VFNChr3gKCBcaN7U/sD
amREYWaa4SOSGlSDwshrXi0JQiKkhB5qA6Ny0PP7WF/Y4MfZZ+291vnOWmuv
giMnosd9EASnQQjsd0HQCBKgDpwHt0EfaALnQC/oAXFQA86CGKgGhxHjKChH
0Ahog60d3ADXFTMhH/ryHM8fA1u8xWCshViHwEGsm6WJ2i6AB+AhuAg+gk9g
HLwC+fAZRqwSUID1NGwzYAK80dkp8Fo+67zFY9wcrEec+fDMsDNdDWCrN30f
9E1+6yV4CybBGuxlgw6sb4Iu0OlMB/WkQGlgOujDs1kgTTEZK92bRp7h3mpv
OqalnZqpo0H12ob1DnAH6x5wHzzX/9JnRHVivViHVnAZ3AKnwEnt9alGPMM4
jNcPegPbY/07dKZbMRnrCjgj22LoWOStR/oUl71SAdtdxaTWMnAosD5hf8QV
r1uxfkoDv/1LfZJQrLjWjf/1Ir/bLS1LvO01q2+bpLNNvXfNmQ7quad/3AX2
sTbwLfH25Hs12Owtp9RDXT/UlzFp5f+2Kzed6vGYNMd1hpqo7SpYqnWrtNA2
pJ5kTw2CFBh1VscR2bjHHnkC6sEBZ/eC96FWNq55t4pli4IisID/4+xehbTm
Xo1s+c5sPOfBRqw3sW8Vq9CZrVjxwrIVyfcdcpOD53owqbx+B1+V36j01Omb
rOss+O2svnzy/Qv4ozV9v8nGOzilHDFX72HLxTOPOQlMR1T/QD2lyk+9/iEL
VIG9IBvsBLtBBkjXk+97QCbYDipBGuurZ6X8eD4POapgH4AN3vyq9J1M2SsU
h/5znIV4Rtz8P5VhHXj7X9q4Rxv3SqS9VjnnXrlqUCi/MtXBaR3RXlh5YQ6m
AsvPWmf1YZ0mlFvWZ045Zt1ylVfWjzHDyiX7gb34AoypJ5fBNqBeXO5tDj8C
Lc7mMWcYZ9lKPFd4mzX0ZxzORPb9U2cx2P+8N+z5Z87uT5fOptz8neJe0tkd
btH3HoNLisN4g9LEGclZydm5ypuNd4dzlno5Gz87m8Gcs9TKWZ7hTfO4YtA3
09u3qYV3cVhneYZ79ElKH/eGpCWp9aA0J2X/d+cHlEfOA84ZzkPORc6bftVo
VjNwTHpnlP+/x1z8+A==
           "]], 
          Polygon3DBox[{{325, 328, 327, 279, 277}, {444, 535, 534, 483, 
           445}, {222, 275, 277, 279, 223}, {377, 425, 423, 433, 378}, {205, 
           210, 209, 64, 40}, {238, 294, 292, 300, 239}, {449, 483, 481, 493, 
           450}, {369, 408, 410, 412, 370}, {373, 427, 426, 425, 374}, {550, 
           38, 40, 64, 551}, {234, 296, 295, 294, 235}, {450, 466, 465, 412, 
           410}, {122, 133, 132, 560, 559}}], Polygon3DBox[CompressedData["
1:eJxF0ksvg0EUxvFpQzcIwkZbpOKydr8sCCGICrFiQyLBpq1LEO1au9bakGCL
L8CXYIEgCIIgCHZs/SfzJBa/zLznzOXMzBuanB2JeY0xAfhwgRyPMXkoQD4u
iV0b1y9EMYpwQyxMu4IEUkhiEGlyz3jFO96QQTu5Kcwgigg60EwRu+T3cYgD
tBAbpz03/zVcYQLdzJnDApawiB5sa68PfOETOwiSG1BtYxhFqWpIYx2b2EAM
Q8w5wZnuxNYwjD7ttYy4zt6PI3Ll1FuGbL6zcEysU2e0a86r5i60IsjYAKZ1
J204NW6uD7ke9xa2hkrGVSCEGr6rUUW/hHyvagjrjH40ktvS2feMu9smYkna
BzzhRW+UQkR3a9/0DreIaq69w2/84kdvFNeYezxqzQRq2WNVa9p/YA11xOq9
rm//AftGtrYGnd1vz4GM3sL+G3+iSk+M
           "]]}],
        Lighting->Automatic]}, 
      {RGBColor[1, 1, 0], Opacity[0.5], EdgeForm[None], 
       StyleBox[
        GraphicsGroup3DBox[{
          Polygon3DBox[{{446, 485, 447}, {164, 176, 240}, {375, 382, 428}, {
           147, 149, 160}, {593, 45, 49}, {330, 337, 379}, {48, 594, 44}, {62,
            65, 78}, {283, 289, 334}, {159, 161, 171}, {448, 454, 486}, {77, 
           81, 93}, {236, 243, 297}, {360, 405, 362}, {170, 172, 185}, {135, 
           136, 148}, {106, 110, 120}, {184, 186, 190}, {178, 188, 173}, {206,
            264, 207}, {411, 416, 451}, {315, 361, 316}, {42, 47, 63}, {92, 
           96, 107}}], Polygon3DBox[CompressedData["
1:eJxNl0lsV1UUh997VQoIiFWwCqJ1WCCRoUBboEWkMrSAmopMRYRSoNpEBAQX
ViYXFEoLiYRBYkxwWBg3IoWKkUkQkURNBEMIMY1B48I4ojIp/n6cj+jiyzs9
99xzz/Tu/7WgZmHVs1mSJKfFdaKn+EQcFbeJm8URdF4bIh4WJ8SXYq5YJNrF
GdFPfC6+EP1FLntse1AcEpfEZfGx6MrzsOguOogD2HUWZVn48N6Rkq/Xcz82
HbA59D9f3fF1hNhbRZvYJz5i7W/xDzb2ad8XxYNZ+L1AjNf8XmbPYc4+j41t
J1MD536Kmrl2n4re4j5xnJr0w861yk9VT/GD5B9FX8l9xBbJb4g3xVZ8eo9t
89Lwm+qZiWOSd4i3yPO9JHReyxGfoWsl9+FZ6LyWm0Zcf+m5GT/nkbfhcwfy
q+JtdJa3i3fQ9SZXn3unaCJu5+Tc7k7izOPUYjk2XjubxOwsR27HxzH2eK/n
7kripKOujnEHeV1IY4/39kqjpkexTanVEXp9BV+lokxMEhPFQNk9KWaJQaJF
ug3idfJ0n/unYXeJuRiI7WVmw3JhGjPiGfIsDdDfo7I4e7DkIWnEYCwPTSPO
BLmImFPkYnpsn/ZtH/a1XjTTh230skSMoKdrsfGae5nLWqnolEZsnfUsSyPG
dUnM3Fb6slq8LF6hDqvQWW5hbzfnho885nisKGctD3kUORQTo2Ntxs92cvhD
uoYk4v4zDdYSu2dzJTG0kPeKJHTN5PlSEjk0MUcN2KzHZzmxvSCW+Cndi6JR
rBFLxTJydp7Po1vNuUvQreLcxehWcs4D8jlDVKcxJ+656zpTPJSFrpoZG0gf
Z4s5zMR5fNjOs7aQM1aQyyBm8ylmbAh7a5ibQtZm4/s5arKcd2sotnOZqyLk
WvpSJ5unk6iL61BG3xaK+jTuet9xvod8559LI8YGejeAOagn52X4WkNNFyRx
xjLqOkfUkqP9FBNLHTPitXnUeDHyfHpg3ShmawkxzueMpdgcTOK3pjOzfoLY
85jNntwTlczFWK2NE1PFFPEEz3nEOYW1+ehsO15MQz8mCR/X9tYT13axRYzG
xmtVSdR+o9hE3p6LdaKJPntWGtF5bSpnLSCGcvE4PXFvfuUM+/5N8gaxV3zI
OZa/FWfR7RanxRmxR9ylffeIe0VBEjqvfSPa0rhjfdf6t+MiOq+1iw/EHUn4
8N4+SejaOdNnT8ziN8L3+iTJo8Va6Xe5j5JvT8KH9/ZKIkbH+p3YJyZk8Ztq
H/ZlH/bl34ZHssi5irn6nRmsp/Y+Z7j0I8QEUSmGJaGzXCEK/Y7QI9fR71YL
dayBDdTSvZsumxm8M3XI1eIZdH4Pm/FhX4PpmXvl76Crd5B4V7yWRmz+TZpI
jL5L1jADnoUJrM3knF/SiHk0vXfsRczgGGajJolvksnMqvOczhxVck41sVeg
m4FNFbNaS02LRQl+PPu+a9aTo3MtwmYcMcxilm1j2xJqXoEP34kz6Y1nYRrn
1jHjtyYxE56FfHrsXvvb4VHJlVl8h3omPBv52I6grz3YN5xzvcd7/e31mOSd
vtP0PKnn+8zhAfG9+Iq49zDnzdDGrLfwXrbyHjXBbvZ4r9+lvuJ+3qmfpcth
ztw7f2MPZhZy6ZXv7EX0zHeX7yzfVb7D/M3l7yx/w7Yy4+6L785z+O7EDBci
d2EmrMujJsPo443oSuhbF3TF7GmkLq3k2kLue3kPXOs+zKxrPj6Lb25/a1dI
voUe5nPuuOy/73Lb2sa27qF7WUCdRibxXXZTEj56EGc3dHnEOTaLb/6u+FZI
V/8n8P8CY/R3Rz1vIC/Xwnmc4s5zn2xz7f8G+yrNoifuhf/X8P9CHdmbg69u
nG2fP6Vhk0NvN3Kv+q7axLu7kxo2ovPafrGZO28Xs/Y178EWZtB617aAWrjG
9nOSHJzLv8ROezU=
           "]], Polygon3DBox[CompressedData["
1:eJwt0E0rRGEUAOCXEn6AUkpN2fi2VEI2FmIytijJwoyaWViMmrKxsLQwY5Rk
RBY+SlZYKWWj/AoLCws1f8AzdRZP733PPffcc05ms7RSbE8p9dDBKdf80eSX
UltKu5zT4Ix5FqiwT5lpuTNkybHEAYdUqXHMDbe88Mozn3Sq0U0XX+6Tzm0K
5Jlq/Vv8gjvuo84qa+xQpMCW3Con1KLOoPgEI4wzxLLhh51jjLb6dl+M3tfZ
iNq9vu8jSy5m/xb/od9zJt7XYz/vfPDGlZwnHniM/eajzz0qlDmK/TS4jDkH
os9Z5mK//1WBMZg=
           "]]}],
        Lighting->Automatic]}, {}, {}, {}, {}, {}}, {
      {GrayLevel[0], 
       Line3DBox[{187, 507, 508, 509, 510, 511, 512, 513, 514, 515, 516, 517, 
        518, 519, 520, 521, 522, 523, 524, 525, 526, 527, 528, 529, 530, 531, 
        532, 533, 534, 535, 536, 537, 538, 539, 540, 541, 542, 543, 544, 545, 
        546, 547, 548, 549, 550, 551, 552, 553, 554, 555, 556, 557, 558, 559, 
        560, 561, 562, 563, 564, 565, 566, 567, 568, 569, 571, 187}]}, 
      {GrayLevel[0], 
       Line3DBox[{1, 581, 582, 583, 584, 585, 586, 587, 588, 589, 590, 591, 
        592, 593, 49, 45, 46, 207, 264, 265, 316, 361, 362, 405, 406, 447, 
        485, 484, 482, 480, 478, 476, 474, 472, 469, 580, 434, 391, 346, 301, 
        248, 191, 5, 1}], 
       Line3DBox[{4, 572, 573, 574, 575, 576, 577, 578, 579, 470, 467, 486, 
        454, 451, 416, 413, 428, 382, 379, 337, 334, 289, 286, 297, 243, 240, 
        176, 173, 188, 178, 163, 151, 138, 125, 112, 98, 83, 67, 51, 4}], 
       Line3DBox[{47, 44, 594, 48, 41, 35, 32, 29, 26, 23, 20, 17, 14, 11, 8, 
        2, 494, 495, 496, 497, 498, 499, 500, 501, 502, 503, 504, 505, 506, 
        570, 189, 190, 186, 185, 172, 171, 161, 160, 149, 148, 136, 123, 120, 
        110, 107, 96, 93, 81, 78, 65, 63, 47}]}}},
    VertexNormals->CompressedData["
1:eJztWnk81OsaV1IklfaQNk4lSadFqTw50WZNjl2KZMmuiBZLnEqoSBvSQpIQ
k30s5UTEMGRpTBs5oVkslXb3dedV12jOUM69nXvyBx9fz+f7Pu/z+z3L9xnT
Te21zAfz8PBooW+8POxfLcD2e04vkz/Fudmx83PD2Xm+1p+ButcPnh88A8Oz
gm5Z8M6ZBnp7r1g9tqSCuIp/3nMnInjnHjPJRrjD0JwbN62oYJ5etXrJTiKU
7ctbm4/w5ObU+HMIv7ZsYdkOhP937sXJvr88A+1PX8/rrz//f7jjWLmG6Jc0
eLZp1hkpBwqcEPnpjoxgxje+P3314/uJw1+NnzJyuuSI4ry8si1f3JECdmTC
hdvDM8Bb8cDH4Y40sHlkVVXrTIWVb19W7fP41vztq3/fT3wGCg/bmq0+GcVz
kNGJBRdQPF/sX2V6AsXTLMnLNMIB1cmaE2/kXahwNy8iyOGb62Rf/ft+4tNf
fM0Sl6LbKG6FxMVyJ3ZRwfDNax+lXUQo1XURL0JxjhuiSj/uSIVfJ96y0f8R
z09fycZu90koPuEPlyd7oPisi1ebq47ic3J6rFwSwo86VfDNcaKCxilm9BOH
/9+4PaDYl2x4RYPQqXtE/W0p4Kq07qMNfwacPb26IQPFgV4plyGJ4tAZqEZt
tiPCJP97+QEIj9c7p3YR4WY0xlwrp6+Nz/cftzCiv7keum9AenFTPrpvfbS5
2K59RNjXfteyEOGinYwLMej90XJ4ECXoTITIpSunTnGigUDYbm0dByq0afnM
1nIe6Ph8P3GLWSZxwQ7VnyFeoaNfobptMfxaIw3lUYZ7WzkDxWfxyKaL01F8
lKT5mbLoPZEY5SqWjPDTB9Wbp6J4XmxVlsn46vz6fuITm9D+cUcSDQx1k01S
vGoh59gZ2WB6Bqjs1Dm9/SMNpGh7lkk4U0B4qaqj+5pUuGpIXOtGo4OuvLRJ
sUoVkBQF/rgZdP0vzyPSIqHRKoJMMDIJzF8uVPppbjeYMOPACoTLuI0/IDHy
M/7n5/X9XF3m2YdX6xkQpkz1LUkpA0JHZBk8t4Tuc+d+8dze/MKPFz+3a6VD
kFKi3hStKmjSkR/GLxgLFgGzn2amMOD9uWkqgx6QYfRGo6XPfjo3YPFMCdEa
XzWcCczpbmP9xn1rfAZKr3Hj7S/P3w9Pwn38Gu7jZriPh+I+7oH7+Moeffxr
z/3095wRT1h9M42P1TezZFl9Mxz3zTrcN1/jvimC+2Yk7pv6Pfpmb/6zuO8c
xX1n/BVW3/HCfUcQ9x3AfSca950Poay+09qj7/Tmj8d1u82TVbfNcN3OxnV7
Fq7ba3Dd/gnX7WBct0/1qNu9+atyL95bifyxGERIfGBPBfFNhs7xiMcpWPvp
DcSzutx6ajviH3Sk/ckJ5Gccb1BpIsJlj73QE0f8QWfveF125Mxvols5Rwvx
5+xcO4SO+Bc0OR24ZEOEzk1puV1z71UTs9mDEc/BFZ6N0rZEaPLcul8J2fOt
3CzSZX9rudVuoT/xf+txM8IoxKMTkbH2xk4q+CrHXL2L7LVCGSpd8T/fKp7S
gvwfpkRzvoCer2LuKXIQwqM2+Ao9ReceSt7VIWDLmV+CFD7RFfnjNufuc0nk
z3zVSeQae9Qfa6bltRfQ4HHSz5UmSrUwt/LDmuu86TC202cGjzMddn40p27Y
UQP33MPXtc5K4cgv8uzSSR8eOmx+2Pn2qRUFJEQCUuOVU8FJ/vY8rSd0cIsi
f0iwqYIjF1riqxKTQKra+u3OeQwoNnyUYSlVCfNCZytnbb7Ikb8yyGq7CKrb
p6iXh60Z/bkebrJLmKufzoBDLUKuLk/JXPOom+dkH3k0EybIPK1jQFHZwqrK
5DKwlnF/IBUSCOKitTpD/RnAO1ZV5eCoCqAPWZVWJ7Z/wPL923i+X3wzzqN8
nEdSOI/e4zwi4DzahfOoEefRMJxH17+YRwPl56e/f8rHX3E+euN8VMf5mIDz
cQTORwWcj4k4HyO45KMszsd1OB/lcT4+nan87/hEOAZL5SL8yKaZDo4I3/Db
u0JFhDvy7g4WQPWWErVdoN2OM78S3huvxHtj5gbW3tiLbW9sgPfGJLw3zsZ7
48Qee+Pe/N4TWXvCg4qsPeGBmf+5J+xtf3ULa99VeYu17zKksPZdnnjf5YT3
XRt77Lt681Rmahg7B9Jg4XFJt0eCVLC7mLb4ZlAmvCwXCngbQIPDk6xt3EdS
YZUnZcG5g5kcec7Qhyq8RXVgsMaJQ2sHf64DZ0ymQyLCq2RvHqoZyn3u6i/P
2JA0i6MIN964cEkLfyncI/sHuButhtPYvprNXnO75V3RGwzYde3+Mf/nZFC5
UdimOfY8aJ9JnlIVzQBJGJ2ZoF4OmiOMrIdqhsDs1lu/tJrR4cTv1jPSK2tg
8DGfBu9wAsc4yMRLtKihuhfnoBme9x91jxO+1DjtWnkamqu1788Z1UiGklrF
KeMTV/+oe1zwHZtZ7795Cev9zyL13PfuwO//si++/18fz3C8/3xvyNp/NuP9
pwXef0bi/Wd5j/1nb571eO+Xhfd+pnjvV4L3fjfw3k+vx96vNw8Bz8/ReH5W
5bAHU/ni/PyZZ2oDax7e1O7+73n44rKee6QmPA+/wfOwKJ6Ho/A8rMZlHn71
WtwmEdUZW7Pqn4agOtNRZPDk/LFMeNYeKFvYTAMDymKHHCIFQkpTZ5BE0uCC
74qDktl0+PkXySKaRDVQ5GNnv4tP4sjfrYs3c9DFC/qoi7npa2k2nm57wz7a
F0iPCdx0jwFDHziWn5Agg0NJXnZzsxdMu6CdEEpnQEncZYObNmXQsv1QnGaJ
KcQ52SXEZtHh1rxnc5NUqoGv2fCdk1wCNES11KvsZcDyY6ovVmhWgBrFd3jr
XfZ5759bN85h/eWJ9RcP1l8+WH8NwvprKdZfV9j0V/sX9dfAz0UErOMeYB23
Deu4HKzjprPt32ZjHReAdVwoFx1XiXXcDqzjJLCOc8Y6DrCOE8Q67hrWcUuw
jgvhouO24PkzC8+fU/H86alqGCSaRwOfO3oLQjfUQp6ttV/bq3TofBeTuHMV
HdLa2vIr4D5MrfNYrM1M5axzo7WbJ6P6MN8zaU9lDgUo2TfHn5yUBrPXz5hp
mUAH9aJBXj9vrYZDi60yc8kEeFtssXTsJAY4rZUWunS2EsRexgV2REZy1UFn
2PTLL84s/XKZ1D8dxIknmo3nr7afZXy5TLiaAfJz+a884iPD7b1RvIPWhkBM
/TKelR4MSBCXlpcwqYCyyvGrmyp8/3F1YyHWCyuwXlDEeqER64WjWC8cxXpB
HesFY6wXqF/UCwNfH1Zh3bER644CrDv2YN3hh3WHFNYdhVh3VGHd4clFd9wc
ydIdzRYs3TGTi+44i+dzunrP+fwsnrdT+zjn95en257BZh+K7RM52LdwsI9n
1wVV9bZO/Eywqdk/2VK+FGTX6cc82mcM3fYENvuKQ4dk1PwZ8Hsp6VJifTnc
pAjzOWyKhFMGY3RlchmQnVos/PgcGfjlDHbYTwsDy7gb4q9b6XBkacdsPuEq
qH3wjDCOwnmeESOw9EKZek+98LU4mQ2/FRx8eXkyA0pj00X8eMpBg/dn8CMY
/+PqwCtvkaGJk5jg9mFJdYlqCRS33C7yV48DpUz3oUkItxIW31eAcFFTBaM6
tbgBi8/z5kBqCOL/EE6P2qNeAvWGErnemnEwQeCIVCnCN94OWfhqQwlEZB3+
jV+V/dzPPN3zpwHb/Bk33zLL5RYTWotsx8VuzOnz3Ms+P3fzvGbj4WY/5O6X
7dnn6m57fg72JhzsB7HZbx3D97qQxICivOKjmevIkFnm73JU3x8Cbqpdz7zI
hCL1gmLlVXlwelahSkGME3Ss8JpiKcCADRObDBSIlWC/jd78ID0eplXmrLym
wYSYER6EO2OKgOYe6Tecdp5j/PFPbvHtY770l+fva/9Qwqyzs5MJsWqVh5WN
+YGum70oQPGZAif7ve1utC570ZelmyPnLICP06oFS+tGD1g+2nTytnTxrx81
WJPn/fxP9t34Og44J/sN/eRht/dTr2vswk/Kbau+IrAQDIJiJjQU8UG3v5zu
8QP/Ms7p819uen8em37v7+cdnPZ+3XtOnj7uObv9NO7jfqPbz9N91DWc5of+
zmnc+lELWx/hlEf4Of7P54OBxhVSyt533Vf3qKWL+G1RkJo3RcHg+FsFI5p8
aBeeoEgyidy7GiKFbBulNs0E7XkiKhpoHhh33Jf3D60S2C9qLpuqHQeiqdER
jUiny3ckOcsh/R7wITprC9IFuVaEtDIHGpxzPe6+dhcV9FuTpv/qSoQoadL8
Rch+WIW0BcmZCgahAbmCLkRgPtIxe+xAhw5DfYsmkxrQmaBmM+lMKgxW+OjB
tKfD8jGLrm/fVgMdCcsIPGdT4Vau5whTxCOjZXXPHfGIX1zvR0L66OT1PPkQ
pI+E3wfzHbajwkbjUOUpyJ9QfYHkAmTvvb7lkjfyc/Fvv0s37iLCtjXaj7rw
iY+Iq4sQTp/swDBzJEJd+NUaa8QzPrpwd5cuu+P4K4WJeMRnLVouhXDGouY3
dxF+et5j14TdnO33a8gwByE86v21GCbSayIqbpqHHZA+Mn1idACdmy+WVU9w
okJHiq9kszMRNk6r9XqD4paQpaNL30mFisu2R/IRz5w7m0nrEV4zokGO6EqF
fa5x9kTk5wvpgFVd+1VNr3FifyD/9xlINgqheylfXVu/Gp2b8rpas0s/Goql
xfEgfj23w5lde6cw09bn95G972ABjTYUNz8bvXfTkH3z6PSX+sjP8wFFE6ej
c4OPO4Z7I/uHrmuyU7v+f8DKSZeKeAxG/m7Gj3Deut2aLshPqRnB7/ej57ig
7U3FSYS7iNdOtEH2I//IVTuM7IeoyZXEoeeb52ig9XhLDdhsUdnPOJ0KYmTW
cy8+z3ru/kqs565T6HnZDN1XLqzQnYzen9feNQn0w0S4fm+JD8OeBkx+HaoX
isO2htuPZ/kTwdnHvXYnwl88X3k/1J0KxzbCFQZ6LsZANrBGODH25TISwt8K
bydYINycFBgmjO5L+MV8sg26r8NCSY8qpE9HG8xZkdRCg/tRVub1RyngMzWi
7oB5OkgunqDewaSBoeutCNVgCtBVyxVit6ZDTJiGLsUL3auswWqdUw2cWZWd
FRaTwLE/FpBkNT3SGHA+UcxsaRMZwnjpS2xpu7nMdX83/Pupc39vvHe8/wUK
kHyf
     "]], {}},
  Axes->True,
  BoxRatios->{1, 1, 1},
  DisplayFunction->Identity,
  FaceGridsStyle->Automatic,
  ImageSize->{345.7637003028007, 356.82143715605986`},
  ImageSizeRaw->Automatic,
  Method->{"RelieveDPZFighting" -> True, "DefaultBoundaryStyle" -> Directive[
      GrayLevel[0.3]], 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}},
  PlotRange->{{0, 10}, {0, 30}, {0, 130}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->{Automatic, Automatic, Automatic},
  ViewPoint->{2.4704352728563803`, -1.9377759659135434`, 1.2617344683232123`},
  
  ViewVertical->{0.18925359096189082`, -0.16002455768928397`, 
   0.9688009182718493}]], "Output",
 CellChangeTimes->{3.917599521265532*^9},
 CellLabel->"Out[55]=",ExpressionUUID->"f323e7c1-acca-4813-a124-bc54fea514de"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Maximize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"4", 
       SubscriptBox["x", "1"]}], "+", 
      RowBox[{"2", 
       SubscriptBox["x", "2"]}], "+", 
      SubscriptBox["x", "3"]}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["x", "1"], "<=", " ", "5"}], "&&", 
      RowBox[{
       RowBox[{
        RowBox[{"4", 
         SubscriptBox["x", "1"]}], "+", 
        SubscriptBox["x", "2"]}], "<=", "25"}], "&&", 
      RowBox[{
       RowBox[{
        RowBox[{"8", 
         SubscriptBox["x", "1"]}], "+", 
        RowBox[{"4", 
         SubscriptBox["x", "2"]}], "+", 
        SubscriptBox["x", "3"]}], "<=", "125"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["x", "1"], ",", 
     SubscriptBox["x", "2"], ",", 
     SubscriptBox["x", "3"]}], "}"}], ",", "NonNegativeReals"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.9175985229005127`*^9, 3.91759853093929*^9}, {
   3.917598588640785*^9, 3.917598664701714*^9}, 3.917598861591908*^9, {
   3.917598941141478*^9, 3.9175989451186438`*^9}, 3.917599013134437*^9, {
   3.9175991070683126`*^9, 3.917599108219154*^9}, {3.917599678227848*^9, 
   3.917599717295663*^9}, {3.917599777731949*^9, 3.9175997974693527`*^9}, {
   3.917599840034137*^9, 3.917599883971977*^9}, {3.917599920137353*^9, 
   3.917599974631302*^9}},
 CellLabel->"In[64]:=",ExpressionUUID->"07b4c403-7088-493c-9c2f-3b94c3efe2ac"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"125", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["x", "1"], "\[Rule]", "0"}], ",", 
     RowBox[{
      SubscriptBox["x", "2"], "\[Rule]", "0"}], ",", 
     RowBox[{
      SubscriptBox["x", "3"], "\[Rule]", "125"}]}], "}"}]}], "}"}]], "Output",\

 CellChangeTimes->{{3.917598655317811*^9, 3.9175986839423723`*^9}, 
   3.91759877660851*^9, 3.917598889067135*^9, {3.91759894184109*^9, 
   3.917598946865511*^9}, 3.9175991132287703`*^9, 3.917599666116303*^9, {
   3.917599790949273*^9, 3.9175997978536787`*^9}, {3.917599875515004*^9, 
   3.917599880782613*^9}, 3.917599974940214*^9},
 CellLabel->"Out[64]=",ExpressionUUID->"302a700a-f307-4cb1-9795-fa2d217f92de"]
}, Open  ]]
},
WindowSize->{1105, 834},
WindowMargins->{{Automatic, 257}, {Automatic, -944}},
FrontEndVersion->"13.0 for Mac OS X x86 (64-bit) (December 2, 2021)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"79ff3a03-a424-4e19-9104-724d1613e5f0"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 1521, 39, 52, "Input",ExpressionUUID->"1e678bd6-d3dd-4f45-902c-870f474fdfce"],
Cell[2104, 63, 17107, 296, 374, "Output",ExpressionUUID->"f323e7c1-acca-4813-a124-bc54fea514de"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19248, 364, 1435, 39, 30, "Input",ExpressionUUID->"07b4c403-7088-493c-9c2f-3b94c3efe2ac"],
Cell[20686, 405, 725, 17, 57, "Output",ExpressionUUID->"302a700a-f307-4cb1-9795-fa2d217f92de"]
}, Open  ]]
}
]
*)

