#EMBOSS - webtool for a pairwise sequence alignment
#http://www.ebi.ac.uk/Tools/emboss/

#dowload package seqinr
#install.packages("seqinr")
library("seqinr")

#download two fasta files
download.file("http://www.uniprot.org/uniprot/Q9CD83.fasta", "Q9CD83.fasta")
download.file("http://www.uniprot.org/uniprot/A0PQ23.fasta", "A0PQ23.fasta")

#read fasta
leprae <- read.fasta(file = "Q9CD83.fasta")
ulcerans <- read.fasta(file = "A0PQ23.fasta")

getSequence(leprae)
getAnnot(leprae)
getName(leprae)

lepraeseq <- leprae[[1]]
ulceransseq <- ulcerans[[1]]

#draw a DOT plot
dotPlot(lepraeseq, ulceransseq)

#dowload Biostrings package from bioconductor
#source("https://bioconductor.org/biocLite.R")
#biocLite("Biostrings")
library(Biostrings)
#score matrix for nucleotides
sigma <- nucleotideSubstitutionMatrix(match = 2, mismatch = -1, baseOnly = TRUE)
sigma

#global alignment
s1 <- "GAATTC"
s2 <- "GATTA"
globalAligns1s2 <- pairwiseAlignment(s1, s2, substitutionMatrix = sigma, gapOpening = -2,
                                     gapExtension = -8, scoreOnly = FALSE)
globalAligns1s2

#score matrix for proteins
data(BLOSUM50)
BLOSUM50
data(package="Biostrings")

#global alignment
s3 <- "PAWHEAE"
s4 <- "HEAGAWGHEE"
globalAligns3s4 <- pairwiseAlignment(s3, s4, substitutionMatrix = "BLOSUM50", gapOpening = -2,
                                     gapExtension = -8, scoreOnly = FALSE)
globalAligns3s4

#local alignment
pairwiseAlignment(s3, s4, substitutionMatrix = "BLOSUM50", gapOpening = -2,
                  gapExtension = -8, scoreOnly = FALSE, type="local")

lepraeseqstring <- toupper(c2s(lepraeseq))
ulceransseqstring <- toupper(c2s(ulceransseq))


globalAlignLepraeUlcerans <- pairwiseAlignment(lepraeseqstring, ulceransseqstring,
                                               substitutionMatrix = BLOSUM50, gapOpening = -2, gapExtension = -8, scoreOnly = FALSE)

globalAlignLepraeUlcerans


localAlignLepraeUlcerans <- pairwiseAlignment(lepraeseqstring, ulceransseqstring,
                                              substitutionMatrix = BLOSUM50, gapOpening = -2, gapExtension = -8, scoreOnly = FALSE, type="local")

localAlignLepraeUlcerans

source("printR.R")
printPairwiseAlignment(globalAlignLepraeUlcerans)

