/*
 * Decompiled with CFR 0.152.
 */
package cvut.fel.controller.interceptors;

import cvut.fel.controller.interceptors.DetailedLoggingStrategy;
import cvut.fel.controller.interceptors.LoggingStrategy;
import cvut.fel.controller.interceptors.ShortLoggingStrategy;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

@Component
public class LoggerInterceptor
implements HandlerInterceptor {
    private final LoggingStrategy strategy;

    @Autowired
    public LoggerInterceptor(ShortLoggingStrategy shortLoggingStrategy, DetailedLoggingStrategy detailedLoggingStrategy, @Value(value="${requestLogging.detail}") Boolean detailedLogging) {
        this.strategy = detailedLogging != false ? detailedLoggingStrategy : shortLoggingStrategy;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        this.strategy.logPreHandle(request);
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        this.strategy.logPostHandle(request);
    }
}

