#include "weather.h"
#include "ui_weather.h"

#include <QtCharts/QAreaSeries>
#include <QtCharts/QChartView>
#include <QtCharts/QLineSeries>
#include <QtCharts/QDateTimeAxis>
#include <QtCharts/QValueAxis>

#include <QNetworkAccessManager>
#include <QtNetwork/QNetworkReply>
#include <QtNetwork/QNetworkRequest>
#include <QEventLoop>

#include <QJsonDocument>
#include <QJsonObject>

#include <QImage>

weather::weather(QWidget *parent)
    : QMainWindow(parent)
    , ui(new Ui::weather)
{
    ui->setupUi(this);

    this->forecastView();
    this->on_btnUpdate_clicked();
}

weather::~weather()
{
    delete ui;
}

void weather::forecastView(void){
    // nacti predpoved z https://api.openweathermap.org/data/2.5/forecast?q=prague&appid=9015878572d5a56d22bafb7d1e71c92e
    QNetworkAccessManager *mgr = new QNetworkAccessManager;
    QNetworkRequest req(QString("url"));
    QNetworkReply *reply = mgr->get(req);
    QEventLoop evtLoop;
    QObject::connect(mgr, &QNetworkAccessManager::finished, &evtLoop, &QEventLoop::quit);
    evtLoop.exec();

    // pokud nedostaneme odpoved, zde skoncime
    // pro korektni funkcnost odkomentovat return
    // zakomentovany return je zejmena pro zobrazeni grafu
    if(reply->error() != QNetworkReply::NoError){
        qDebug() << "ERROR forecastView";
        // return;
    }

    // nacti data a preved na JSON objekt
    QString data = reply->readAll();
    QJsonDocument json = QJsonDocument::fromJson(data.toUtf8());
    QJsonObject   jsonObject = json.object();

    // pocet hodnot pro zobrazeni
    int listCount = jsonObject["cnt"].toInt();

    // vytvoreni prubehu teploty
    QLineSeries *dataTemperature = new QLineSeries();
    dataTemperature->setName("Teplota");

    // definice min a max pro osu X
    QJsonObject     jsonListMin = jsonObject["list"][0].toObject();
    QDateTime       timeMin     = QDateTime::fromSecsSinceEpoch(jsonListMin["dt"].toInt());
    QJsonObject     jsonListMax = jsonObject["list"][listCount-1].toObject();
    QDateTime       timeMax     = QDateTime::fromSecsSinceEpoch(jsonListMax["dt"].toInt());

    // dummy hodnoty pro vykresleni grafu
    timeMin = QDateTime::currentDateTime();
    timeMax = timeMin.addDays(7);
    listCount = 80;

    // nacteni dat
    for (int i = 0; i < listCount; ++i) {
        // TODO: prochazet data v JSON souboru a zobrazit jako bod v grafu
        QDateTime time = timeMin.addSecs(i * 3 * 3600);     // krok 3 hodiny
        double teplota = 15 + qSin(i / 3.0) * 5;            // sinusovy prubeh
        *dataTemperature << QPointF(time.toMSecsSinceEpoch(), teplota);
    }

    // vytvoreni grafu
    QChart *chart = new QChart();
    chart->setTitle(QString("Predpoved Pocasi"));
    chart->addSeries(dataTemperature);

    // nastaveni osy X
    QDateTimeAxis *dateTimeAxis = new QDateTimeAxis;
    chart->addAxis(dateTimeAxis, Qt::AlignBottom);
    dataTemperature->attachAxis(dateTimeAxis);
    dateTimeAxis->setTickCount(7);
    dateTimeAxis->setFormat("dd.MM hh:mm");
    dateTimeAxis->setTitleText("Datum");
    dateTimeAxis->setMin(timeMin.addSecs(0));
    dateTimeAxis->setMax(timeMax.addSecs(0));

    // nastaveni osy Y
    QValueAxis *axisY = new QValueAxis;
    chart->addAxis(axisY, Qt::AlignLeft);
    dataTemperature->attachAxis(axisY);
    axisY->setTitleText("Teplota");
    axisY->setRange(10, 20);

    // TODO:
    // zobrazit vlhkost nebo tlak na grafu s osou Y vpravo
    ui->chartForecast->setChart(chart);
}

void weather::getIcon(QString icon){
    QNetworkAccessManager *mgr = new QNetworkAccessManager;
    QNetworkRequest req(QString("http://openweathermap.org/img/wn/%1@2x.png").arg(icon));
    QNetworkReply *reply = mgr->get(req);
    QEventLoop evtLoop;
    QObject::connect(mgr, &QNetworkAccessManager::finished, &evtLoop, &QEventLoop::quit);
    evtLoop.exec();

    if(reply->error() != QNetworkReply::NoError){
        qDebug() << "ERROR getIcon";
        return;
    }

    // TODO: nacist a zobrazit obrazek jako pixmap
}

void weather::on_btnUpdate_clicked()
{
    // TODO
    // 1a, nacist aktualni data z https://api.openweathermap.org/data/2.5/weather?q=prague&appid=9015878572d5a56d22bafb7d1e71c92e
    // 1b, pridat moznost vyberu mista
    // QNetworkAccessManager *mgr;
    // QNetworkRequest req(url);
    // QNetworkReply *reply = mgr->get(req);
    // QEventLoop evtLoop;
    // QObject::connect(mgr, &QNetworkAccessManager::finished, &evtLoop, &QEventLoop::quit);
    // evtLoop.exec();

    // if(reply->error() != QNetworkReply::NoError){
    //     qDebug() << "ERROR btnUpdate";
    //     return;
    // }

    // nacteni dat z odpovedi
    // QString data = reply->readAll();

    // 2, vytvorit JSON objekty z JSON dokumentu
    // QJsonDocument json        = QJsonDocument::fromJson(data.toUtf8());
    // QJsonObject   jsonMain    = json["xxx"].toObject();

    // 3, extrahovat data z json
    // double temp       = jsonMain["xxx"].toDouble();
    // QDateTime sunset  = QDateTime::fromSecsSinceEpoch(int);

    // 4, vypsat data do UI
    // ui->lblSunset->setText(sunset.toString("hh:mm"));

    // 5, zobrazit ikonu

}

