#include <iostream>
#include <string>
#include <chrono>
#include <thread>
#include <future>

using namespace std::chrono;

std::string funkce1 (std::string arg) {
	// funkce ceka 5 vterin
	std::this_thread::sleep_for(seconds(2));

	return "funkce1: " + arg;
}

std::string funkce2 (std::string arg) {
	// funkce ceka 5 vterin
	std::this_thread::sleep_for(seconds(2));

	return "funkce2: " + arg;
}

int main() {
	
	system_clock::time_point start, end;
    std::string data, f1data, f2data;
    // zacatek synchronniho volani
    start = system_clock::now();

    // synchronni volani funkci
	f1data = funkce1 ("sync");
	f2data = funkce2 ("sync");

	// konec synchronniho volani
	end = system_clock::now();

	auto diff = duration_cast < std::chrono::seconds > (end - start).count();
	std::cout << "sync call duration: " << diff << " seconds" << std::endl;

	data = f1data + " :: " + f2data;
	std::cout << "data: " << data << std::endl;

    // zacatek asynchronniho volani funkce1
    start = system_clock::now();
    std::future<std::string> asyncf1data = std::async(funkce1, "async");
    f2data = funkce2 ("sync");
    // ziskani dat z asychronniho volani musi probehnout az po normalnim volani, get() ceka na vysledek 
    f1data = asyncf1data.get();
    // konec asynchronniho volani
	end = system_clock::now();
    diff = duration_cast < std::chrono::seconds > (end - start).count();
    std::cout << "async call duration: " << diff << " seconds" << std::endl;

    data = f1data + " :: " + f2data;
	std::cout << "data: " << data << std::endl;

	return 0;
}