#include <iostream>
#include <thread>
#include <mutex>

#define DEADLOCK

struct Krabice
{
    explicit Krabice (int pocet) : kulicky (pocet) {}
    int kulicky;
    std::mutex m;
};

void transfer (Krabice &from, Krabice &to, int num)
{
#ifndef DEADLOCK
    // zajistí správné zamčení zámku bez deadlocku
    std::lock (from.m, to.m);
#endif

#ifdef DEADLOCK
    std::lock_guard<std::mutex> l1(from.m);
#else
    std::lock_guard<std::mutex> l1(from.m, std::adopt_lock);
#endif
    std::cout << "from -> " << num << "\n";
    from.kulicky -= num;
    std::this_thread::sleep_for(std::chrono::milliseconds(10));
#ifdef DEADLOCK
    std::lock_guard<std::mutex> l2(to.m);
#else
    std::lock_guard<std::mutex> l2(to.m, std::adopt_lock);
#endif
    std::cout << "to <- " << num << "\n";
    to.kulicky += num;
}

int main()
{
    Krabice a(20), b(10);
    std::thread t1 (transfer, std::ref(a), std::ref(b), 10);
    std::thread t2 (transfer, std::ref(b), std::ref(a), 7);

    t1.join();
    t2.join();

    return 0;
}