#include <iostream>
#include <vector>
#include <algorithm>

/*
    [zachytavane promenne] (formalni promenne) {telo lambda vyrazu} (skutecne parametry);

    [zachytavane promenne] (formalni promenne) -> navratovy typ {telo lambda vyrazu} (skutecne parametry);

    zachytavani promennych:
    [] - nic
    [x] - predam hodnotu x hodnotou do LV
    [&x] - predavam referenci na x -> muzu ovlivnit hodnotu te promenne
    [a, &b] - a je zachycena jako hodnota, b zachycena jako reference
    [=] - vsechny jako hodnoty
    [&] - vsechny jako reference
    [=, &x] - vsechny prommenne jsou zachyceny jako hodnoty, pouze x jako reference
    [this] - zachyti platny ukazatel this
*/

bool compare (int i, int j) {
    return i < j;
}

int main() {

    // lambda vyraz
    std::cout << [](int a, int b)->int{return a+b;}(3, 5)  << "\n";
    // funkce jako ukazatel na lambda vyraz
    auto f = [](int a, int b)->int{return a*b;}; // std::function
    // volani funkce vytvorene z lambda vyrazu
    std::cout << f(10, 2) << "\n";

    std::vector<int> a {2, 3, 6, 3, 9, 2, 3, 4, 5, 6};

    // serazeni vektoru vzestupne pomoci funkce
    std::sort(a.begin(), a.end(), compare);
    for (auto i : a) std::cout << i << " ";
    std::cout << std::endl;

    // serazeni vektoru sestupne pomoci lambda vyrazu
    std::sort(a.begin(), a.end(), [](int a, int b){return a > b;});
    for (auto i : a) std::cout << i << " ";
    std::cout << std::endl;

    // naplneneni vektoru posloupnosti cisel zacinajici hodnotou 'start'
    std::vector<int> b(10);
    int start = 10;

    // zachyceni referenci
    generate(b.begin(), b.end(), [&start]{return ++start;});
    for (auto i : b) std::cout << i << " ";
    std::cout << ", start = " << start << std::endl;

    // zachyceni hodnotou + mutable
    generate(b.begin(), b.end(), [start] () mutable {return ++start;});
    for (auto i : b) std::cout << i << " ";
    std::cout << ", start = " << start << std::endl;

    // naplnime novy vektor velikosti 10 prvku int posloupnosti 
    // 1 - 10. ridici promenna bude inicializovana v seznamu 
    // zachycenych promennych (od c++14)
    std::vector<int> c(10);
    generate(c.begin(), c.end(), [s=0] () mutable {return ++s;});
    for (auto i : c) std::cout << i << " ";
    std::cout << std::endl;

    // prekopirujeme do vektoru d cisla z d, ktera jsou vetsi nez 5
    // threshold pro kopirovani by se pochopitelne dal nastavit promennou 
    std::vector<int> d(10);
    std::copy_if (c.begin(), c.end(), d.begin(), [](int i){return i > 5;});
    for (auto i : d) std::cout << i << " ";
    std::cout << std::endl;

    return 0;
}
