#include <iostream>

template<class T> class Stack1
{
    T* items;
    int size;
    int pointer;
public: 
    Stack1 (int _size = 10) : size(_size), pointer(0) {
        items = new T[size];
    } 
    ~Stack1 () {
        delete [] items;
    }
    void push (T item);
    T pop ();
};

template<class T, int size> class Stack2
{
    T items[size];
    int pointer = 0;
public:
    void push (T item) {items[pointer++] = item;}
    T pop() {return items[--pointer];}
};

template<class T>
void Stack1<T>::push(T item) {
    items[pointer++] = item;
}

template<class T>
T Stack1<T>::pop() {
    return items[--pointer];
}

int main()
{
    Stack1<int> a(10); // zasobnik o velikosti 10 prvku
    a.push(10);
    a.push(20);
    std::cout << a.pop() << "\n";
    std::cout << a.pop() << "\n";

    Stack2<float, 10> c;
    c.push(3.14);
    c.push(2.71);
    std::cout << c.pop() << "\n";
    std::cout << c.pop() << "\n";

    return 0;
}
