#ifndef OSCILLOSCOPE_H
#define OSCILLOSCOPE_H

#include <QMainWindow>
#include <QTimer>
#include <QtSerialPort/QSerialPort>

#include <QtCharts/QAreaSeries>
#include <QtCharts/QChartView>
#include <QtCharts/QLineSeries>
#include <QtCharts/QDateTimeAxis>

#include "settingsdialog.h"

QT_BEGIN_NAMESPACE
namespace Ui {
class oscilloscope;
}
QT_END_NAMESPACE

class SettingsDialog;

class oscilloscope : public QMainWindow
{
    Q_OBJECT

    void openSerialPort(void);
    void closeSerialPort();
    QString dataBuffer;

    QLineSeries *dataActual;
    QAreaSeries *dataValues;
    QChart *chart;

public:
    oscilloscope(QWidget *parent = nullptr);
    ~oscilloscope();

private slots:
    void on_btnStart_clicked();
    void on_btnStop_clicked();
    void on_btnOpenPort_clicked();
    void on_btnSettings_clicked();


    //void about();
    void writeData(const QByteArray &data);
    void readData();

    void handleBytesWritten(qint64 bytes);
    void handleWriteTimeout();


private:
    Ui::oscilloscope *ui;

    qint64 m_bytesToWrite = 0;
    QTimer *m_timer = nullptr;
    QSerialPort *m_serial = nullptr;
    SettingsDialog *m_settings = nullptr;
};
#endif // OSCILLOSCOPE_H
