
#ifndef __LOGIC_HPP__
#define __LOGIC_HPP__

#include <iostream>
#include <queue>

enum class BARVA_KULICKY  {
    BARVA_PRVNI,
    BARVA_BILA,
    BARVA_CERNA,
    BARVA_MODRA,
    BARVA_CERVENA,
    BARVA_DUHOVA,
    BARVA_POSLEDNI,
    BARVA_KULICKA_DOSLA,
};

inline std::ostream &operator<<(std::ostream &out, BARVA_KULICKY k){
    switch (k) {       
        case BARVA_KULICKY::BARVA_BILA:
            out << "Bila";
            break;      
        case BARVA_KULICKY::BARVA_CERNA:
            out << "Cerna";
            break;      
        case BARVA_KULICKY::BARVA_CERVENA:
            out << "Cervena";
            break;      
        case BARVA_KULICKY::BARVA_DUHOVA:
            out << "Duhova";
            break;      
        case BARVA_KULICKY::BARVA_MODRA:
            out << "Modra";
            break;  
        
        default:
            out << "Neznama barva";
            break;
    }
    return out;
}

class Logik {
    std::queue<BARVA_KULICKY> uzivatelskaKombinace;
    std::vector<BARVA_KULICKY> tajnaKombinace;
    int time = 0;
    int pocet = 5;
    bool konec = 0;

public:
    Logik(void);
    void incTime(void){++time;}
    int getTime(void){return time;}

    void novaHra(void);
    void barvy(void);
    void nactiRadu(void);
    void vyhodnotRadu(void);
    bool nalezeno(void);

    void uzivatelPush(BARVA_KULICKY barva);
    BARVA_KULICKY uzivatelPop(void);
};


#endif // __LOGIC_HPP__