#include "Logik.hpp"
#include <iostream>
#include <iomanip>

Logik::Logik(void){
    this->tajnaKombinace.push_back(BARVA_KULICKY::BARVA_BILA);
    this->tajnaKombinace.push_back(BARVA_KULICKY::BARVA_BILA);
    this->tajnaKombinace.push_back(BARVA_KULICKY::BARVA_BILA);
    this->tajnaKombinace.push_back(BARVA_KULICKY::BARVA_BILA);
    this->tajnaKombinace.push_back(BARVA_KULICKY::BARVA_BILA);
    // this->tajnaKombinace.push_back(BARVA_KULICKY::BARVA_CERNA);
    // this->tajnaKombinace.push_back(BARVA_KULICKY::BARVA_DUHOVA);
    // this->tajnaKombinace.push_back(BARVA_KULICKY::BARVA_MODRA);
    // this->tajnaKombinace.push_back(BARVA_KULICKY::BARVA_BILA);
    this->pocet = this->tajnaKombinace.size();
    this->konec = false;
}

void Logik::uzivatelPush(BARVA_KULICKY barva){
    this->uzivatelskaKombinace.push(barva);
}

BARVA_KULICKY Logik::uzivatelPop(void){
    if(this->uzivatelskaKombinace.empty())
        return BARVA_KULICKY::BARVA_KULICKA_DOSLA;

    BARVA_KULICKY kulicka = this->uzivatelskaKombinace.front();
    this->uzivatelskaKombinace.pop();
    return kulicka;
}

void Logik::novaHra(void){

}

bool Logik::nalezeno(void){
    return this->konec;
}

void Logik::barvy(void){
    std::cout << "Zadej "<< this->pocet << " kulicek: " << std::endl;
    for(int i=(int)BARVA_KULICKY::BARVA_PRVNI+1; i< (int)BARVA_KULICKY::BARVA_POSLEDNI; i++){
        std::cout << "[" << (int) i << "]: " << (BARVA_KULICKY) i << std::endl;
    }
}

void Logik::nactiRadu(void){
    int barvy[5];
    for(int i=0; i<this->pocet; i++){
        std::cin >> barvy[i];
        if((barvy[i] > (int) BARVA_KULICKY::BARVA_PRVNI) && (barvy[i] < (int) BARVA_KULICKY::BARVA_POSLEDNI)){
            this->uzivatelPush((BARVA_KULICKY) barvy[i]);
        }
        else{
            --i;
        }
    }
}

void Logik::vyhodnotRadu(void){
    int correct = 0;
    int color = 0;

    for(int i=0; i<this->pocet; i++){
        BARVA_KULICKY barva = this->uzivatelPop();
        std::cout << std::setw(9) << barva;
        if(this->tajnaKombinace.at(i) == barva){
            ++correct;
        }
        else{
            for(int j=0; j<this->pocet; j++){
                if(barva == this->tajnaKombinace.at(j)){
                    ++color;
                    break;
                }
            }
        }
    }    
    // statistika
    std::cout << std::setw(25) << "Spravne/Barva   " << correct << "/"  << color;
    std::cout << std::setw(7) << ((float)this->time)/10 << " s" << std::endl;
    
    for(int i=0; i<this->pocet; i++){
        std::cout << std::setw(9) << this->tajnaKombinace.at(i);
    }
    std::cout << std::endl;

    if(correct == this->pocet)
        this->konec = true;
}

