#include "kresleni.h"
#include "qpainter.h"
#include "ui_kresleni.h"

#include <QFileDialog>
#include <QColorDialog>

kresleni::kresleni(QWidget *parent)
    : QMainWindow(parent)
    , ui(new Ui::kresleni)
{
    ui->setupUi(this);


}

void kresleni::paintDraw(void){
    // rozmery
    int x = ui->lblPainter->size().width();
    int y = ui->lblPainter->size().height();

    QPixmap pixmap(x, y);
    QPainter p(&pixmap);

    ui->lblPainter->setPixmap(pixmap);
}

void kresleni::paintBrush(void){

}

void kresleni::paintEvent(QPaintEvent *event){
    Q_UNUSED(event);

    switch(this->paintTool){
    case TOOL_IMAGE:
        break;

    case TOOL_COLOR:
        break;

    case TOOL_EMPTY:
        break;

    case TOOL_DRAW:
        this->paintDraw();
        break;

    case TOOL_BRUSH:
        this->paintBrush();
        break;
    }
}

kresleni::~kresleni()
{
    delete ui;
}

void kresleni::on_rbStyleDot_toggled(bool checked)
{
    if(checked){
        this->lineStyle = Qt::DotLine;
    }
}


void kresleni::on_rbStyleSolid_toggled(bool checked)
{
    if(checked){
        this->lineStyle = Qt::SolidLine;
    }
}


void kresleni::on_rbStyleDash_toggled(bool checked)
{
    if(checked){
        this->lineStyle = Qt::DashLine;
    }
}


void kresleni::on_rbFontArial_toggled(bool checked)
{
    if(checked){
        this->font = "Arial";
    }
}


void kresleni::on_rbFontComics_toggled(bool checked)
{
    if(checked){
        this->font = "Comic Sans MS";
    }
}


void kresleni::on_rbFontTimes_toggled(bool checked)
{
    if(checked){
        this->font = "Times New Roman";
    }
}

