#!/usr/bin/env python3
# -*- coding: utf-8 -*-

from .Message import Message

class Vector3(Message):
    """
    Basic class for representing 3D vector
    Data entries:
    float64 x
    float64 y
    float64 z
    """
    __attributes__ = ['x','y','z']
    __attribute_types = ['float64','float64','float64']
    
    def __init__(self, *args, **kwds):
        super(Vector3, self).__init__(*args, **kwds)
        #message fields cannot be None - fill in zeros instead
        if self.x == None:
            self.x = 0.0
        if self.y == None:
            self.y = 0.0
        if self.z == None:
            self.z = 0.0

#Examples of usage
if __name__=="__main__":
    x = Vector3()
    print(x.x, x.y, x.z)

    x = Vector3(1, 2, 3)
    print(x.x, x.y, x.z)

    x = Vector3(x=2,z=1)
    print(x.x, x.y, x.z)
