# Authors: Jiri Kubik (kubikji2@fel.cvut.cz)

import numpy as np

class GeneralFrictionModel():

    def __init__(   self,
                    minimal_friction_coefficient : float = 0.1,
                    maximal_friction_coefficient : float = 2.0):
        self.minimal_friction_coefficient = minimal_friction_coefficient
        self.maximal_friction_coefficient = maximal_friction_coefficient
    
    def step(self):
        # mu_h < mu_s_f < mu_s_h

        # mu_s_f in range(mu_min, mu_max)
        self.forward_friction = np.random.uniform(self.minimal_friction_coefficient, self.maximal_friction_coefficient)
        # mu_s_b in range (mu_s_f, mu_max)
        self.backward_friction = np.random.uniform(self.forward_friction, self.maximal_friction_coefficient)
        # mu_h in range (mu_min, mu_s_f)
        self.stiff_friction = np.random.uniform(self.minimal_friction_coefficient, self.forward_friction)


    def get_stiff_friction(self):
        return self.stiff_friction


    def get_soft_friction_forward(self):
        return self.forward_friction


    def get_soft_friction_backward(self):
        return self.backward_friction