#include <random>
#include <algorithm>

using namespace std;

vector<double> generateRandomVector(int n, int seed = -1) {
    vector<double> u(n);

    random_device randomDevice;
    mt19937 randomEngine(seed == -1 ? randomDevice() : seed);

    uniform_real_distribution<double> distribution(1.0, 10.0);
    generate(u.begin(), u.end(), [&randomEngine, &distribution] { return distribution(randomEngine); });

    return u;
}

double computeVectorLength(double * u, int length) {
    double sumSquares = 0;
    for (int i = 0; i < length; i++) {
        sumSquares += u[i] * u[i];
    }

    return sqrt(sumSquares);
}
