#include <iostream>
#include <iomanip>
#include <mpi.h>
#include "Utils.hpp"


int main(int argc, char** argv) {
    MPI_Init(&argc, &argv);

    int rank, size;
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);
    MPI_Comm_size(MPI_COMM_WORLD, &size);

    int vectorSize = 16; // Vector size
    int chunkSize = vectorSize / size; // Size of vector chunk for each process

    double *localVector = (double*)malloc(chunkSize * sizeof(double));
    double *globalVector = (double*)malloc(vectorSize * sizeof(double));

    if (rank == 0) {
        // Process with rank 0 generates vector
        auto u = generateRandomVector(vectorSize);
        for (int i = 0; i < vectorSize; i++) {
            globalVector[i] = u[i];
        }
    }

    // TODO

    // Printing vector on process with rank 0
    if (rank == 0) {
        cout << "Normalized Vector: {";
        for (int i = 0; i < vectorSize; i++) {
            cout << std::fixed << std::setprecision(2) << globalVector[i] << " ";
        }
        cout << "}" << endl;
        cout << "Vector length is " << computeVectorLength(globalVector, vectorSize) << endl;
    }

    MPI_Finalize();

    free(localVector);
    free(globalVector);

    return 0;
}