import csv
from rdflib import Graph, Namespace, RDF, Literal, XSD, RDFS

# Initialize graph and namespace
graph = Graph()
ppr = Namespace("http://bindetad.com/parkandride/")
graph.bind('ppr', ppr)
geo = Namespace("http://www.w3.org/2003/01/geo/wgs84_pos#")
graph.bind('geo', geo)
pprtype = ppr["ParkAndRide"]

with open('5d88f52c-78ee-4de3-ad18-9b844737cd63-parking.csv', encoding="utf8") as csvfile:
    csvreader = csv.reader(csvfile, delimiter=",")
    # Skip header
    next(csvreader, None)
    for row in csvreader:
        # If parking lot is not a P+R, skip it
        if not bool(row[3]):
            continue
        name = str(row[0])
        subject = ppr[name.replace(" ", "_")]
        graph.add((subject, RDF.type, pprtype))
        graph.add((subject, RDFS.label, Literal(name, datatype=XSD.string)))
        graph.add((subject, geo["lat"], Literal(row[1], datatype=XSD.string)))
        graph.add((subject, geo["long"], Literal(row[2], datatype=XSD.string)))
        graph.add((subject, ppr["capacity"], Literal(int(row[4]), datatype=XSD.integer)))

graph.serialize(destination="par.ttl", format="turtle")
