import glob
import csv
import os
from datetime import datetime
from rdflib import Graph, Namespace, RDF, Literal, XSD, URIRef

# Initialize graph and namespace
graph = Graph()
dpp = Namespace("http://bindetad.com/dppsales/")
graph.bind('dpp', dpp)
dpptype = dpp["PassSalesRecord"]
line = 0

# Get all CSVs in directory
files = glob.glob("./dpp/*.csv")

for file in files:
    # Ignore any empty CSVs
    if os.path.getsize(file) == 0:
        continue
    print(file)
    with open(file, encoding="utf8") as csvfile:
        # Detect delimiter
        delimiter = csv.Sniffer().sniff(csvfile.read(1024), delimiters=";,")
        csvreader = csv.reader(csvfile, delimiter)
        # Skip header
        next(csvreader, None)
        # Get year and month of entries from filename
        date = datetime.strptime(file[6:13], "%Y_%m")
        places = {}
        for row in csvreader:
            # The columns differ with each sale type, which we need to account for with our import strategy
            if file.endswith("Papirove.csv"):
                passtype = "Paper"
                place = str(row[0])
                if not place in places:
                    places[place] = int(row[3])
                else:
                    places[place] += int(row[3])
            elif file.endswith("Karta.csv"):
                passtype = "Electronic"
                place = str(row[0])
                if not place in places:
                    places[place] = int(row[3])
                else:
                    places[place] += int(row[3])
            elif file.endswith("ESHOP.csv"):
                passtype = "Electronic"
                if not "Eshop" in places:
                    places["Eshop"] = int(row[2])
                else:
                    places["Eshop"] += int(row[2])

        for place in places:
            subject = URIRef(u"http://bindetad.com/dppsales/"+str(date.year)+"/"+str(date.month)+"/"+str(place).replace(" ", "_"))
            graph.add((subject, RDF.type, dpptype))
            graph.add((subject, dpp["month"], Literal(date.month, datatype=XSD.integer)))
            graph.add((subject, dpp["year"], Literal(date.year, datatype=XSD.integer)))
            graph.add((subject, dpp["passType"], Literal(passtype, datatype=XSD.string)))
            graph.add((subject, dpp["boughtAt"], Literal(place, datatype=XSD.string)))
            graph.add((subject, dpp["count"], Literal(places[place], datatype=XSD.integer)))
            line += 1

graph.serialize(destination="dpp.ttl", format="turtle")
